/*
 * Decompiled with CFR 0.152.
 */
package elki.evaluation.clustering.internal;

import elki.data.Clustering;
import elki.data.NumberVector;
import elki.data.model.Model;
import elki.data.type.TypeInformation;
import elki.database.Database;
import elki.database.ids.DBIDRef;
import elki.database.relation.Relation;
import elki.database.relation.RelationUtil;
import elki.distance.NumberVectorDistance;
import elki.distance.minkowski.EuclideanDistance;
import elki.evaluation.Evaluator;
import elki.evaluation.clustering.internal.NoiseHandling;
import elki.evaluation.clustering.internal.SimplifiedSilhouette;
import elki.evaluation.clustering.internal.VarianceRatioCriterion;
import elki.logging.Logging;
import elki.logging.statistics.DoubleStatistic;
import elki.logging.statistics.LongStatistic;
import elki.logging.statistics.Statistic;
import elki.logging.statistics.StringStatistic;
import elki.math.linearalgebra.Centroid;
import elki.result.EvaluationResult;
import elki.result.Metadata;
import elki.result.ResultUtil;
import elki.utilities.documentation.Reference;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.EnumParameter;
import elki.utilities.optionhandling.parameters.ObjectParameter;
import java.util.List;
import net.jafama.FastMath;

@Reference(authors="M. K. Pakhira, S. Bandyopadhyay, U. Maulik", title="Validity index for crisp and fuzzy clusters", booktitle="Pattern recognition, 37(3)", url="https://doi.org/10.1016/j.patcog.2003.06.005", bibkey="DBLP:journals/pr/PakhiraBM04")
public class PBMIndex
implements Evaluator {
    private static final Logging LOG = Logging.getLogger(PBMIndex.class);
    private NoiseHandling noiseHandling;
    private NumberVectorDistance<?> distance;
    private String key = PBMIndex.class.getName();

    public PBMIndex(NumberVectorDistance<?> distance, NoiseHandling noiseOpt) {
        this.distance = distance;
        this.noiseHandling = noiseOpt;
    }

    /*
     * Unable to fully structure code
     */
    public double evaluateClustering(Relation<? extends NumberVector> rel, Clustering<?> c) {
        clusters = c.getAllClusters();
        centroids = new NumberVector[clusters.size()];
        ignorednoise = SimplifiedSilhouette.centroids(rel, clusters, centroids, this.noiseHandling);
        dim = RelationUtil.dimensionality(rel);
        overallCentroid = new Centroid(dim);
        VarianceRatioCriterion.globalCentroid(overallCentroid, rel, clusters, centroids, this.noiseHandling);
        max = 0.0;
        for (i = 0; i < centroids.length; ++i) {
            if (centroids[i] == null && this.noiseHandling != NoiseHandling.TREAT_NOISE_AS_SINGLETONS) continue;
            for (j = i + 1; j < centroids.length; ++j) {
                if (centroids[j] == null && this.noiseHandling != NoiseHandling.TREAT_NOISE_AS_SINGLETONS) continue;
                if (centroids[i] == null && centroids[j] == null) {
                    iti = clusters.get(i).getIDs().iter();
                    while (iti.valid()) {
                        itj = clusters.get(j).getIDs().iter();
                        while (itj.valid()) {
                            dist = this.distance.distance((NumberVector)rel.get((DBIDRef)iti), (NumberVector)rel.get((DBIDRef)itj));
                            max = dist > max ? dist : max;
                            itj.advance();
                        }
                        iti.advance();
                    }
                    continue;
                }
                if (centroids[i] == null) {
                    iti = clusters.get(i).getIDs().iter();
                    while (iti.valid()) {
                        dist = this.distance.distance((NumberVector)rel.get((DBIDRef)iti), centroids[j]);
                        max = dist > max ? dist : max;
                        iti.advance();
                    }
                    continue;
                }
                if (centroids[j] == null) {
                    itj = clusters.get(j).getIDs().iter();
                    while (itj.valid()) {
                        dist = this.distance.distance(centroids[i], (NumberVector)rel.get((DBIDRef)itj));
                        max = dist > max ? dist : max;
                        itj.advance();
                    }
                    continue;
                }
                dist = this.distance.distance(centroids[i], centroids[j]);
                max = dist > max ? dist : max;
            }
        }
        a = 0.0;
        b = 0.0;
        nCl = clusters.size();
        ci = clusters.iterator();
        i = 0;
        while (ci.hasNext()) {
            cluster = ci.next();
            if (cluster.size() > 1 && !cluster.isNoise()) ** GOTO lbl-1000
            switch (1.$SwitchMap$elki$evaluation$clustering$internal$NoiseHandling[this.noiseHandling.ordinal()]) {
                case 1: {
                    --nCl;
                    break;
                }
                case 2: {
                    it = cluster.getIDs().iter();
                    while (it.valid()) {
                        b += this.distance.distance((NumberVector)overallCentroid, (NumberVector)rel.get((DBIDRef)it));
                        it.advance();
                    }
                    nCl += cluster.size() - 1;
                    break;
                }
                default: lbl-1000:
                // 2 sources

                {
                    it = cluster.getIDs().iter();
                    while (it.valid()) {
                        obj = (NumberVector)rel.get((DBIDRef)it);
                        a += this.distance.distance(centroids[i], obj);
                        b += this.distance.distance((NumberVector)overallCentroid, obj);
                        it.advance();
                    }
                    break block0;
                }
            }
            ++i;
        }
        pbm = FastMath.pow((double)(1.0 / (double)nCl * (b / a) * max), (double)2.0);
        if (PBMIndex.LOG.isStatistics()) {
            PBMIndex.LOG.statistics((Statistic)new StringStatistic(this.key + ".pbm.noise-handling", this.noiseHandling.toString()));
            if (ignorednoise > 0) {
                PBMIndex.LOG.statistics((Statistic)new LongStatistic(this.key + ".pbm.ignored", (long)ignorednoise));
            }
            PBMIndex.LOG.statistics((Statistic)new DoubleStatistic(this.key + ".pbm", pbm));
        }
        ev = EvaluationResult.findOrCreate(c, (String)"Internal Clustering Evaluation");
        g = ev.findOrCreateGroup("Distance-based");
        g.addMeasure("PBM-Index", pbm, 0.0, Infinity, 0.0, false);
        if (!Metadata.hierarchyOf(c).addChild((Object)ev)) {
            Metadata.of((Object)ev).notifyChanged();
        }
        return pbm;
    }

    public void processNewResult(Object result) {
        List<Clustering<Model>> crs = Clustering.getClusteringResults(result);
        if (crs.isEmpty()) {
            return;
        }
        Database db = ResultUtil.findDatabase((Object)result);
        Relation rel = db.getRelation((TypeInformation)this.distance.getInputTypeRestriction(), new Object[0]);
        for (Clustering<Model> c : crs) {
            this.evaluateClustering((Relation<? extends NumberVector>)rel, c);
        }
    }

    public static class Par
    implements Parameterizer {
        public static final OptionID DISTANCE_ID = new OptionID("pbm.distance", "Distance function to use for computing PBM.");
        public static final OptionID NOISE_ID = new OptionID("pbm.noisehandling", "Control how noise should be treated.");
        private NumberVectorDistance<?> distance;
        private NoiseHandling noiseHandling;

        public void configure(Parameterization config) {
            new ObjectParameter(DISTANCE_ID, NumberVectorDistance.class, EuclideanDistance.class).grab(config, x -> {
                this.distance = x;
            });
            new EnumParameter(NOISE_ID, NoiseHandling.class, (Enum)NoiseHandling.TREAT_NOISE_AS_SINGLETONS).grab(config, x -> {
                this.noiseHandling = x;
            });
        }

        public PBMIndex make() {
            return new PBMIndex(this.distance, this.noiseHandling);
        }
    }
}

