/*
 * Decompiled with CFR 0.152.
 */
package elki.evaluation.clustering.internal;

import elki.data.Cluster;
import elki.data.Clustering;
import elki.data.model.Model;
import elki.database.Database;
import elki.database.datastore.DataStoreFactory;
import elki.database.datastore.DoubleDataStore;
import elki.database.datastore.WritableDoubleDataStore;
import elki.database.ids.ArrayDBIDs;
import elki.database.ids.DBIDArrayIter;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDs;
import elki.database.query.QueryBuilder;
import elki.database.query.distance.DistanceQuery;
import elki.database.relation.MaterializedDoubleRelation;
import elki.database.relation.Relation;
import elki.distance.Distance;
import elki.distance.minkowski.EuclideanDistance;
import elki.evaluation.Evaluator;
import elki.evaluation.clustering.internal.NoiseHandling;
import elki.logging.Logging;
import elki.logging.statistics.DoubleStatistic;
import elki.logging.statistics.LongStatistic;
import elki.logging.statistics.Statistic;
import elki.logging.statistics.StringStatistic;
import elki.math.MeanVariance;
import elki.result.EvaluationResult;
import elki.result.Metadata;
import elki.result.ResultUtil;
import elki.utilities.documentation.Reference;
import elki.utilities.io.FormatUtil;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.EnumParameter;
import elki.utilities.optionhandling.parameters.Flag;
import elki.utilities.optionhandling.parameters.ObjectParameter;
import java.util.List;

@Reference(authors="P. J. Rousseeuw", title="Silhouettes: A graphical aid to the interpretation and validation of cluster analysis", booktitle="Journal of Computational and Applied Mathematics, Volume 20", url="https://doi.org/10.1016/0377-0427(87)90125-7", bibkey="doi:10.1016/0377-04278790125-7")
public class Silhouette<O>
implements Evaluator {
    private static final Logging LOG = Logging.getLogger(Silhouette.class);
    public static final String SILHOUETTE_NAME = "Silhouette scores";
    private Distance<? super O> distance;
    private NoiseHandling noiseOption;
    private boolean penalize;
    private static final String key = Silhouette.class.getName();

    public Silhouette(Distance<? super O> distance, NoiseHandling noiseOption, boolean penalize) {
        this.distance = distance;
        this.noiseOption = noiseOption;
        this.penalize = penalize;
    }

    public Silhouette(Distance<? super O> distance, boolean mergenoise) {
        this(distance, mergenoise ? NoiseHandling.MERGE_NOISE : NoiseHandling.TREAT_NOISE_AS_SINGLETONS, true);
    }

    public double evaluateClustering(Relation<O> rel, DistanceQuery<O> dq, Clustering<?> c) {
        List<Cluster<?>> clusters = c.getAllClusters();
        MeanVariance msil = new MeanVariance();
        int ignorednoise = 0;
        WritableDoubleDataStore silhouettes = DataStoreFactory.FACTORY.makeDoubleStorage(rel.getDBIDs(), 30, 0.0);
        if (clusters.size() <= 1) {
            msil.put(0.0, (double)rel.size());
        } else {
            block8: for (Cluster<?> cluster : clusters) {
                if (cluster.size() <= 1 || cluster.isNoise()) {
                    switch (this.noiseOption) {
                        case IGNORE_NOISE: {
                            ignorednoise += cluster.size();
                            continue block8;
                        }
                        case TREAT_NOISE_AS_SINGLETONS: {
                            msil.put(0.0, (double)cluster.size());
                            DBIDIter it = cluster.getIDs().iter();
                            while (it.valid()) {
                                silhouettes.putDouble((DBIDRef)it, 0.0);
                                it.advance();
                            }
                            continue block8;
                        }
                    }
                }
                ArrayDBIDs ids = DBIDUtil.ensureArray((DBIDs)cluster.getIDs());
                double[] as = new double[ids.size()];
                DBIDArrayIter it1 = ids.iter();
                DBIDArrayIter it2 = ids.iter();
                it1.seek(0);
                while (it1.valid()) {
                    double a = as[it1.getOffset()];
                    it2.seek(it1.getOffset() + 1);
                    while (it2.valid()) {
                        double dist = dq.distance((DBIDRef)it1, (DBIDRef)it2);
                        a += dist;
                        int n = it2.getOffset();
                        as[n] = as[n] + dist;
                        it2.advance();
                    }
                    a /= (double)(ids.size() - 1);
                    double b = Double.POSITIVE_INFINITY;
                    block12: for (Cluster<?> ocluster : clusters) {
                        if (ocluster == cluster) continue;
                        if (ocluster.size() <= 1 || ocluster.isNoise()) {
                            switch (this.noiseOption) {
                                case IGNORE_NOISE: {
                                    continue block12;
                                }
                                case TREAT_NOISE_AS_SINGLETONS: {
                                    DBIDIter it3 = ocluster.getIDs().iter();
                                    while (it3.valid()) {
                                        double dist = dq.distance((DBIDRef)it1, (DBIDRef)it3);
                                        b = dist < b ? dist : b;
                                        it3.advance();
                                    }
                                    continue block12;
                                }
                            }
                        }
                        DBIDs oids = ocluster.getIDs();
                        double btmp = 0.0;
                        DBIDIter it3 = oids.iter();
                        while (it3.valid()) {
                            btmp += dq.distance((DBIDRef)it1, (DBIDRef)it3);
                            it3.advance();
                        }
                        b = (btmp /= (double)oids.size()) < b ? btmp : b;
                    }
                    double s = b < Double.POSITIVE_INFINITY ? (b - a) / (b > a ? b : a) : 0.0;
                    msil.put(s);
                    silhouettes.putDouble((DBIDRef)it1, s);
                    it1.advance();
                }
            }
        }
        double penalty = 1.0;
        if (this.penalize && ignorednoise > 0) {
            penalty = (double)(rel.size() - ignorednoise) / (double)rel.size();
        }
        double meansil = penalty * msil.getMean();
        double stdsil = penalty * msil.getSampleStddev();
        if (LOG.isStatistics()) {
            LOG.statistics((Statistic)new StringStatistic(key + ".silhouette.noise-handling", this.noiseOption.toString()));
            if (ignorednoise > 0) {
                LOG.statistics((Statistic)new LongStatistic(key + ".silhouette.noise", (long)ignorednoise));
            }
            LOG.statistics((Statistic)new DoubleStatistic(key + ".silhouette.mean", meansil));
            LOG.statistics((Statistic)new DoubleStatistic(key + ".silhouette.stddev", stdsil));
        }
        EvaluationResult ev = EvaluationResult.findOrCreate(c, (String)"Internal Clustering Evaluation");
        EvaluationResult.MeasurementGroup g = ev.findOrCreateGroup("Distance-based");
        g.addMeasure("Silhouette +-" + FormatUtil.NF2.format(stdsil), meansil, -1.0, 1.0, 0.0, false);
        if (!Metadata.hierarchyOf(c).addChild((Object)ev)) {
            Metadata.of((Object)ev).notifyChanged();
        }
        Metadata.hierarchyOf(c).addChild((Object)new MaterializedDoubleRelation(SILHOUETTE_NAME, rel.getDBIDs(), (DoubleDataStore)silhouettes));
        return meansil;
    }

    public void processNewResult(Object result) {
        List<Clustering<Model>> crs = Clustering.getClusteringResults(result);
        if (crs.isEmpty()) {
            return;
        }
        Database db = ResultUtil.findDatabase((Object)result);
        Relation relation = db.getRelation(this.distance.getInputTypeRestriction(), new Object[0]);
        DistanceQuery dq = new QueryBuilder(relation, this.distance).distanceQuery();
        for (Clustering<Model> c : crs) {
            this.evaluateClustering(relation, dq, c);
        }
    }

    public static class Par<O>
    implements Parameterizer {
        public static final OptionID DISTANCE_ID = new OptionID("silhouette.distance", "Distance function to use for computing the silhouette.");
        public static final OptionID NOISE_ID = new OptionID("silhouette.noisehandling", "Control how noise should be treated.");
        public static final OptionID NO_PENALIZE_ID = new OptionID("silhouette.no-penalize-noise", "Do not penalize ignored noise.");
        private Distance<? super O> distance;
        private NoiseHandling noiseOption;
        private boolean penalize = true;

        public void configure(Parameterization config) {
            new ObjectParameter(DISTANCE_ID, Distance.class, EuclideanDistance.class).grab(config, x -> {
                this.distance = x;
            });
            new EnumParameter(NOISE_ID, NoiseHandling.class, (Enum)NoiseHandling.TREAT_NOISE_AS_SINGLETONS).grab(config, x -> {
                this.noiseOption = x;
            });
            if (this.noiseOption == NoiseHandling.IGNORE_NOISE) {
                new Flag(NO_PENALIZE_ID).grab(config, x -> {
                    this.penalize = !x;
                });
            }
        }

        public Silhouette<O> make() {
            return new Silhouette<O>(this.distance, this.noiseOption, this.penalize);
        }
    }
}

