/*
 * Decompiled with CFR 0.152.
 */
package elki.evaluation.clustering.internal;

import elki.data.Cluster;
import elki.data.Clustering;
import elki.data.NumberVector;
import elki.data.model.Model;
import elki.data.model.ModelUtil;
import elki.data.type.TypeInformation;
import elki.database.datastore.DataStoreFactory;
import elki.database.datastore.DoubleDataStore;
import elki.database.ids.DBIDRef;
import elki.database.relation.MaterializedDoubleRelation;
import elki.database.relation.Relation;
import elki.distance.NumberVectorDistance;
import elki.distance.minkowski.EuclideanDistance;
import elki.evaluation.Evaluator;
import elki.evaluation.clustering.internal.NoiseHandling;
import elki.evaluation.clustering.internal.Silhouette;
import elki.logging.Logging;
import elki.logging.statistics.DoubleStatistic;
import elki.logging.statistics.LongStatistic;
import elki.logging.statistics.Statistic;
import elki.logging.statistics.StringStatistic;
import elki.math.MeanVariance;
import elki.result.EvaluationResult;
import elki.result.Metadata;
import elki.result.ResultUtil;
import elki.utilities.io.FormatUtil;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.EnumParameter;
import elki.utilities.optionhandling.parameters.Flag;
import elki.utilities.optionhandling.parameters.ObjectParameter;
import java.util.List;

public class SimplifiedSilhouette
implements Evaluator {
    private static final Logging LOG = Logging.getLogger(SimplifiedSilhouette.class);
    private NoiseHandling noiseOption;
    private NumberVectorDistance<?> distance;
    private boolean penalize = true;
    private String key = SimplifiedSilhouette.class.getName();

    public SimplifiedSilhouette(NumberVectorDistance<?> distance, NoiseHandling noiseOpt, boolean penalize) {
        this.distance = distance;
        this.noiseOption = noiseOpt;
        this.penalize = penalize;
    }

    /*
     * Unable to fully structure code
     */
    public double evaluateClustering(Relation<? extends NumberVector> rel, Clustering<?> c) {
        clusters = c.getAllClusters();
        centroids = new NumberVector[clusters.size()];
        ignorednoise = SimplifiedSilhouette.centroids(rel, clusters, centroids, this.noiseOption);
        mssil = new MeanVariance();
        silhouettes = DataStoreFactory.FACTORY.makeDoubleStorage(rel.getDBIDs(), 30);
        ci = clusters.iterator();
        i = 0;
        while (ci.hasNext()) {
            block20: {
                block19: {
                    cluster = ci.next();
                    if (cluster.size() > 1) break block19;
                    mssil.put(0.0, (double)cluster.size());
                    it = cluster.getIDs().iter();
                    while (it.valid()) {
                        silhouettes.putDouble((DBIDRef)it, 0.0);
                        it.advance();
                    }
                    break block20;
                }
                if (!cluster.isNoise()) ** GOTO lbl-1000
                switch (1.$SwitchMap$elki$evaluation$clustering$internal$NoiseHandling[this.noiseOption.ordinal()]) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        mssil.put(0.0, (double)cluster.size());
                        it = cluster.getIDs().iter();
                        while (it.valid()) {
                            silhouettes.putDouble((DBIDRef)it, 0.0);
                            it.advance();
                        }
                        break;
                    }
                    default: lbl-1000:
                    // 2 sources

                    {
                        center = centroids[i];
                        if (!SimplifiedSilhouette.$assertionsDisabled && center == null) {
                            throw new AssertionError();
                        }
                        it = cluster.getIDs().iter();
                        while (it.valid()) {
                            obj = (NumberVector)rel.get((DBIDRef)it);
                            a = this.distance.distance(center, obj);
                            min = Infinity;
                            cj = clusters.iterator();
                            j = 0;
                            while (cj.hasNext()) {
                                ocluster = cj.next();
                                if (i == j) ** GOTO lbl65
                                other = centroids[j];
                                if (other != null) ** GOTO lbl-1000
                                switch (1.$SwitchMap$elki$evaluation$clustering$internal$NoiseHandling[this.noiseOption.ordinal()]) {
                                    case 1: {
                                        break;
                                    }
                                    case 2: {
                                        it2 = ocluster.getIDs().iter();
                                        while (it2.valid()) {
                                            dist = this.distance.distance((NumberVector)rel.get((DBIDRef)it2), obj);
                                            min = dist < min ? dist : min;
                                            it2.advance();
                                        }
                                        break;
                                    }
                                    default: lbl-1000:
                                    // 2 sources

                                    {
                                        min = (dist = this.distance.distance(other, obj)) < min ? dist : min;
                                    }
                                }
lbl65:
                                // 4 sources

                                ++j;
                            }
                            min = min < Infinity ? min : a;
                            s = (min - a) / (min > a ? min : a);
                            mssil.put(s);
                            silhouettes.putDouble((DBIDRef)it, s);
                            it.advance();
                        }
                        break block0;
                    }
                }
            }
            ++i;
        }
        penalty = 1.0;
        if (this.penalize && ignorednoise > 0) {
            penalty = (double)(rel.size() - ignorednoise) / (double)rel.size();
        }
        meanssil = penalty * mssil.getMean();
        stdssil = penalty * mssil.getSampleStddev();
        if (SimplifiedSilhouette.LOG.isStatistics()) {
            SimplifiedSilhouette.LOG.statistics((Statistic)new StringStatistic(this.key + ".simplified-silhouette.noise-handling", this.noiseOption.toString()));
            if (ignorednoise > 0) {
                SimplifiedSilhouette.LOG.statistics((Statistic)new LongStatistic(this.key + ".simplified-silhouette.ignored", (long)ignorednoise));
            }
            SimplifiedSilhouette.LOG.statistics((Statistic)new DoubleStatistic(this.key + ".simplified-silhouette.mean", meanssil));
            SimplifiedSilhouette.LOG.statistics((Statistic)new DoubleStatistic(this.key + ".simplified-silhouette.stddev", stdssil));
        }
        ev = EvaluationResult.findOrCreate(c, (String)"Internal Clustering Evaluation");
        g = ev.findOrCreateGroup("Distance-based");
        g.addMeasure("Simp. Silhouette +-" + FormatUtil.NF2.format(stdssil), meanssil, -1.0, 1.0, 0.0, false);
        if (!Metadata.hierarchyOf(c).addChild((Object)ev)) {
            Metadata.of((Object)ev).notifyChanged();
        }
        Metadata.hierarchyOf(c).addChild((Object)new MaterializedDoubleRelation("Silhouette scores", rel.getDBIDs(), (DoubleDataStore)silhouettes));
        return meanssil;
    }

    /*
     * Unable to fully structure code
     */
    public static int centroids(Relation<? extends NumberVector> rel, List<? extends Cluster<?>> clusters, NumberVector[] centroids, NoiseHandling noiseOption) {
        if (!SimplifiedSilhouette.$assertionsDisabled && centroids.length != clusters.size()) {
            throw new AssertionError();
        }
        ignorednoise = 0;
        ci = clusters.iterator();
        i = 0;
        while (ci.hasNext()) {
            cluster = ci.next();
            if (cluster.size() > 1 && !cluster.isNoise()) ** GOTO lbl-1000
            switch (1.$SwitchMap$elki$evaluation$clustering$internal$NoiseHandling[noiseOption.ordinal()]) {
                case 1: {
                    ignorednoise += cluster.size();
                    centroids[i] = null;
                    break;
                }
                case 2: {
                    centroids[i] = null;
                    break;
                }
                default: lbl-1000:
                // 2 sources

                {
                    centroids[i] = ModelUtil.getPrototypeOrCentroid(cluster.getModel(), rel, cluster.getIDs());
                }
            }
            ++i;
        }
        return ignorednoise;
    }

    public void processNewResult(Object result) {
        List<Clustering<Model>> crs = Clustering.getClusteringResults(result);
        if (crs.isEmpty()) {
            return;
        }
        Relation rel = ResultUtil.findDatabase((Object)result).getRelation((TypeInformation)this.distance.getInputTypeRestriction(), new Object[0]);
        for (Clustering<Model> c : crs) {
            this.evaluateClustering((Relation<? extends NumberVector>)rel, c);
        }
    }

    public static class Par
    implements Parameterizer {
        private NumberVectorDistance<?> distance;
        private NoiseHandling noiseOption;
        private boolean penalize = true;

        public void configure(Parameterization config) {
            new ObjectParameter(Silhouette.Par.DISTANCE_ID, NumberVectorDistance.class, EuclideanDistance.class).grab(config, x -> {
                this.distance = x;
            });
            new EnumParameter(Silhouette.Par.NOISE_ID, NoiseHandling.class, (Enum)NoiseHandling.TREAT_NOISE_AS_SINGLETONS).grab(config, x -> {
                this.noiseOption = x;
            });
            if (this.noiseOption == NoiseHandling.IGNORE_NOISE) {
                new Flag(Silhouette.Par.NO_PENALIZE_ID).grab(config, x -> {
                    this.penalize = !x;
                });
            }
        }

        public SimplifiedSilhouette make() {
            return new SimplifiedSilhouette(this.distance, this.noiseOption, this.penalize);
        }
    }
}

