/*
 * Decompiled with CFR 0.152.
 */
package elki.evaluation.clustering.internal;

import elki.data.Cluster;
import elki.data.Clustering;
import elki.data.NumberVector;
import elki.data.model.Model;
import elki.data.model.ModelUtil;
import elki.data.type.TypeInformation;
import elki.database.Database;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.relation.Relation;
import elki.distance.NumberVectorDistance;
import elki.distance.minkowski.SquaredEuclideanDistance;
import elki.evaluation.Evaluator;
import elki.evaluation.clustering.internal.NoiseHandling;
import elki.logging.Logging;
import elki.logging.statistics.DoubleStatistic;
import elki.logging.statistics.Statistic;
import elki.result.EvaluationResult;
import elki.result.Metadata;
import elki.result.ResultUtil;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.EnumParameter;
import elki.utilities.optionhandling.parameters.ObjectParameter;
import java.util.List;

public class SquaredErrors
implements Evaluator {
    private static final Logging LOG = Logging.getLogger(SquaredErrors.class);
    private NoiseHandling noiseOption;
    private NumberVectorDistance<?> distance;
    private String key = SquaredErrors.class.getName();

    public SquaredErrors(NumberVectorDistance<?> distance, NoiseHandling noiseOption) {
        this.distance = distance;
        this.noiseOption = noiseOption;
    }

    public double evaluateClustering(Relation<? extends NumberVector> rel, Clustering<?> c) {
        boolean square = !this.distance.isSquared();
        int ignorednoise = 0;
        List<Cluster<?>> clusters = c.getAllClusters();
        double ssq = 0.0;
        double sum = 0.0;
        block4: for (Cluster<?> cluster : clusters) {
            if (cluster.size() <= 1 || cluster.isNoise()) {
                switch (this.noiseOption) {
                    case IGNORE_NOISE: {
                        ignorednoise += cluster.size();
                        continue block4;
                    }
                    case TREAT_NOISE_AS_SINGLETONS: {
                        continue block4;
                    }
                }
            }
            NumberVector center = ModelUtil.getPrototypeOrCentroid(cluster.getModel(), rel, cluster.getIDs());
            DBIDIter it1 = cluster.getIDs().iter();
            while (it1.valid()) {
                double d = this.distance.distance(center, (NumberVector)rel.get((DBIDRef)it1));
                sum += d;
                ssq += square ? d * d : d;
                it1.advance();
            }
        }
        int div = Math.max(1, rel.size() - ignorednoise);
        if (LOG.isStatistics()) {
            LOG.statistics((Statistic)new DoubleStatistic(this.key + ".mean", sum / (double)div));
            LOG.statistics((Statistic)new DoubleStatistic(this.key + ".ssq", ssq));
            LOG.statistics((Statistic)new DoubleStatistic(this.key + ".rmsd", Math.sqrt(ssq / (double)div)));
        }
        EvaluationResult ev = EvaluationResult.findOrCreate(c, (String)"Internal Clustering Evaluation");
        EvaluationResult.MeasurementGroup g = ev.findOrCreateGroup("Distance-based");
        g.addMeasure("Mean distance", sum / (double)div, 0.0, Double.POSITIVE_INFINITY, true);
        g.addMeasure("Sum of Squares", ssq, 0.0, Double.POSITIVE_INFINITY, true);
        g.addMeasure("RMSD", Math.sqrt(ssq / (double)div), 0.0, Double.POSITIVE_INFINITY, true);
        if (!Metadata.hierarchyOf(c).addChild((Object)ev)) {
            Metadata.of((Object)ev).notifyChanged();
        }
        return ssq;
    }

    public void processNewResult(Object result) {
        List<Clustering<Model>> crs = Clustering.getClusteringResults(result);
        if (crs.isEmpty()) {
            return;
        }
        Database db = ResultUtil.findDatabase((Object)result);
        Relation rel = db.getRelation((TypeInformation)this.distance.getInputTypeRestriction(), new Object[0]);
        for (Clustering<Model> c : crs) {
            this.evaluateClustering((Relation<? extends NumberVector>)rel, c);
        }
    }

    public static class Par
    implements Parameterizer {
        public static final OptionID DISTANCE_ID = new OptionID("ssq.distance", "Distance function to use for computing the SSQ.");
        public static final OptionID NOISE_ID = new OptionID("ssq.noisehandling", "Control how noise should be treated.");
        private NumberVectorDistance<?> distance;
        private NoiseHandling noiseOption;

        public void configure(Parameterization config) {
            new ObjectParameter(DISTANCE_ID, NumberVectorDistance.class, SquaredEuclideanDistance.class).grab(config, x -> {
                this.distance = x;
            });
            new EnumParameter(NOISE_ID, NoiseHandling.class, (Enum)NoiseHandling.TREAT_NOISE_AS_SINGLETONS).grab(config, x -> {
                this.noiseOption = x;
            });
        }

        public SquaredErrors make() {
            return new SquaredErrors(this.distance, this.noiseOption);
        }
    }
}

