/*
 * Decompiled with CFR 0.152.
 */
package elki.evaluation.clustering.internal;

import elki.data.Cluster;
import elki.data.Clustering;
import elki.data.NumberVector;
import elki.data.model.Model;
import elki.data.type.TypeInformation;
import elki.database.Database;
import elki.database.ids.DBIDRef;
import elki.database.relation.Relation;
import elki.database.relation.RelationUtil;
import elki.distance.minkowski.EuclideanDistance;
import elki.distance.minkowski.SquaredEuclideanDistance;
import elki.evaluation.Evaluator;
import elki.evaluation.clustering.internal.NoiseHandling;
import elki.evaluation.clustering.internal.SimplifiedSilhouette;
import elki.logging.Logging;
import elki.logging.statistics.DoubleStatistic;
import elki.logging.statistics.LongStatistic;
import elki.logging.statistics.Statistic;
import elki.logging.statistics.StringStatistic;
import elki.math.linearalgebra.Centroid;
import elki.result.EvaluationResult;
import elki.result.Metadata;
import elki.result.ResultUtil;
import elki.utilities.Alias;
import elki.utilities.documentation.Reference;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.EnumParameter;
import elki.utilities.optionhandling.parameters.Flag;
import java.util.List;

@Reference(authors="R. B. Calinski, J. Harabasz", title="A dendrite method for cluster analysis", booktitle="Communications in Statistics - Theory and Methods 3(1)", url="https://doi.org/10.1080/03610927408827101", bibkey="doi:10.1080/03610927408827101")
@Alias(value={"calinski-harabasz"})
public class VarianceRatioCriterion
implements Evaluator {
    private static final Logging LOG = Logging.getLogger(VarianceRatioCriterion.class);
    private NoiseHandling noiseOption;
    private boolean penalize = true;
    private String key = VarianceRatioCriterion.class.getName();

    public VarianceRatioCriterion(NoiseHandling noiseOption, boolean penalize) {
        this.noiseOption = noiseOption;
        this.penalize = penalize;
    }

    /*
     * Unable to fully structure code
     */
    public double evaluateClustering(Relation<? extends NumberVector> rel, Clustering<?> c) {
        block11: {
            df = SquaredEuclideanDistance.STATIC;
            clusters = c.getAllClusters();
            vrc = 0.0;
            ignorednoise = 0;
            if (clusters.size() <= 1) break block11;
            centroids = new NumberVector[clusters.size()];
            ignorednoise = SimplifiedSilhouette.centroids(rel, clusters, centroids, this.noiseOption);
            dim = RelationUtil.dimensionality(rel);
            overallCentroid = new Centroid(dim);
            clustercount = VarianceRatioCriterion.globalCentroid(overallCentroid, rel, clusters, centroids, this.noiseOption);
            a = 0.0;
            b = 0.0;
            ci = clusters.iterator();
            i = 0;
            while (ci.hasNext()) {
                cluster = ci.next();
                if (cluster.size() > 1 && !cluster.isNoise()) ** GOTO lbl-1000
                switch (1.$SwitchMap$elki$evaluation$clustering$internal$NoiseHandling[this.noiseOption.ordinal()]) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        it = cluster.getIDs().iter();
                        while (it.valid()) {
                            b += df.distance((NumberVector)overallCentroid, (NumberVector)rel.get((DBIDRef)it));
                            it.advance();
                        }
                        break;
                    }
                    default: lbl-1000:
                    // 2 sources

                    {
                        it = cluster.getIDs().iter();
                        while (it.valid()) {
                            vec = (NumberVector)rel.get((DBIDRef)it);
                            a += df.distance(centroids[i], vec);
                            b += df.distance((NumberVector)overallCentroid, vec);
                            it.advance();
                        }
                        break block0;
                    }
                }
                ++i;
            }
            vrc = (b - a) / a * ((double)(rel.size() - clustercount) / ((double)clustercount - 1.0));
            if (this.penalize && ignorednoise > 0) {
                vrc *= (double)(rel.size() - ignorednoise) / (double)rel.size();
            }
        }
        if (VarianceRatioCriterion.LOG.isStatistics()) {
            VarianceRatioCriterion.LOG.statistics((Statistic)new StringStatistic(this.key + ".vrc.noise-handling", this.noiseOption.toString()));
            if (ignorednoise > 0) {
                VarianceRatioCriterion.LOG.statistics((Statistic)new LongStatistic(this.key + ".vrc.ignored", (long)ignorednoise));
            }
            VarianceRatioCriterion.LOG.statistics((Statistic)new DoubleStatistic(this.key + ".vrc", vrc));
        }
        ev = EvaluationResult.findOrCreate(c, (String)"Internal Clustering Evaluation");
        g = ev.findOrCreateGroup("Distance-based");
        g.addMeasure("Variance Ratio Criteria", vrc, 0.0, 1.0, 0.0, false);
        if (!Metadata.hierarchyOf(c).addChild((Object)ev)) {
            Metadata.of((Object)ev).notifyChanged();
        }
        return vrc;
    }

    /*
     * Unable to fully structure code
     */
    public static int globalCentroid(Centroid overallCentroid, Relation<? extends NumberVector> rel, List<? extends Cluster<?>> clusters, NumberVector[] centroids, NoiseHandling noiseOption) {
        clustercount = 0;
        ci = clusters.iterator();
        i = 0;
        while (ci.hasNext()) {
            cluster = ci.next();
            if (cluster.size() > 1 && !cluster.isNoise()) ** GOTO lbl-1000
            switch (1.$SwitchMap$elki$evaluation$clustering$internal$NoiseHandling[noiseOption.ordinal()]) {
                case 1: {
                    break;
                }
                case 2: {
                    clustercount += cluster.size();
                    it = cluster.getIDs().iter();
                    while (it.valid()) {
                        overallCentroid.put((NumberVector)rel.get((DBIDRef)it));
                        it.advance();
                    }
                    break;
                }
                default: lbl-1000:
                // 2 sources

                {
                    if (!VarianceRatioCriterion.$assertionsDisabled && centroids[i] == null) {
                        throw new AssertionError();
                    }
                    overallCentroid.put(centroids[i], (double)cluster.size());
                    ++clustercount;
                }
            }
            ++i;
        }
        return clustercount;
    }

    public void processNewResult(Object result) {
        List<Clustering<Model>> crs = Clustering.getClusteringResults(result);
        if (crs.isEmpty()) {
            return;
        }
        Database db = ResultUtil.findDatabase((Object)result);
        Relation rel = db.getRelation((TypeInformation)EuclideanDistance.STATIC.getInputTypeRestriction(), new Object[0]);
        for (Clustering<Model> c : crs) {
            this.evaluateClustering((Relation<? extends NumberVector>)rel, c);
        }
    }

    public static class Par
    implements Parameterizer {
        public static final OptionID NOISE_ID = new OptionID("vrc.noisehandling", "Control how noise should be treated.");
        public static final OptionID NO_PENALIZE_ID = new OptionID("silhouette.no-penalize-noise", "Do not penalize ignored noise.");
        private NoiseHandling noiseOption;
        private boolean penalize = true;

        public void configure(Parameterization config) {
            new EnumParameter(NOISE_ID, NoiseHandling.class, (Enum)NoiseHandling.TREAT_NOISE_AS_SINGLETONS).grab(config, x -> {
                this.noiseOption = x;
            });
            if (this.noiseOption == NoiseHandling.IGNORE_NOISE) {
                new Flag(NO_PENALIZE_ID).grab(config, x -> {
                    this.penalize = !x;
                });
            }
        }

        public VarianceRatioCriterion make() {
            return new VarianceRatioCriterion(this.noiseOption, this.penalize);
        }
    }
}

