/*
 * Decompiled with CFR 0.152.
 */
package elki.index.preprocessed.fastoptics;

import elki.data.NumberVector;
import elki.database.datastore.DataStore;
import elki.database.datastore.DataStoreUtil;
import elki.database.datastore.DoubleDataStore;
import elki.database.datastore.WritableDataStore;
import elki.database.datastore.WritableDoubleDataStore;
import elki.database.datastore.WritableIntegerDataStore;
import elki.database.ids.ArrayDBIDs;
import elki.database.ids.ArrayModifiableDBIDs;
import elki.database.ids.DBIDArrayIter;
import elki.database.ids.DBIDArrayMIter;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDVar;
import elki.database.ids.DBIDs;
import elki.database.ids.ModifiableDBIDs;
import elki.database.relation.Relation;
import elki.database.relation.RelationUtil;
import elki.distance.minkowski.EuclideanDistance;
import elki.logging.Logging;
import elki.logging.progress.AbstractProgress;
import elki.logging.progress.FiniteProgress;
import elki.logging.statistics.LongStatistic;
import elki.logging.statistics.Statistic;
import elki.math.MathUtil;
import elki.utilities.documentation.Reference;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.RandomParameter;
import elki.utilities.random.RandomFactory;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Random;

@Reference(authors="J. Schneider, M. Vlachos", title="Fast parameterless density-based clustering via random projections", booktitle="Proc. 22nd ACM Int. Conf. on Information & Knowledge Management (CIKM 2013)", url="https://doi.org/10.1145/2505515.2505590", bibkey="DBLP:conf/cikm/SchneiderV13")
public class RandomProjectedNeighborsAndDensities {
    private static final Logging LOG = Logging.getLogger(RandomProjectedNeighborsAndDensities.class);
    private static final String PREFIX = RandomProjectedNeighborsAndDensities.class.getName();
    private static final int logOProjectionConst = 20;
    private static final float sizeTolerance = 0.6666667f;
    int minSplitSize;
    Relation<? extends NumberVector> points;
    ArrayList<ArrayDBIDs> splitsets;
    DoubleDataStore[] projectedPoints;
    RandomFactory rnd;
    long distanceComputations;

    public RandomProjectedNeighborsAndDensities(RandomFactory rnd) {
        this.rnd = rnd;
    }

    public void computeSetsBounds(Relation<? extends NumberVector> points, int minSplitSize, DBIDs ptList) {
        DBIDIter it;
        this.minSplitSize = minSplitSize;
        int size = points.size();
        int dim = RelationUtil.dimensionality(points);
        this.points = points;
        int nPointSetSplits = (int)(20.0 * MathUtil.log2((double)((double)(size * dim) + 1.0)));
        int nProject1d = (int)(20.0 * MathUtil.log2((double)((double)(size * dim) + 1.0)));
        LOG.statistics((Statistic)new LongStatistic(PREFIX + ".partition-size", (long)nPointSetSplits));
        LOG.statistics((Statistic)new LongStatistic(PREFIX + ".num-projections", (long)nProject1d));
        this.splitsets = new ArrayList();
        this.projectedPoints = new DoubleDataStore[nProject1d];
        DoubleDataStore[] tmpPro = new DoubleDataStore[nProject1d];
        Random rand = this.rnd.getSingleThreadedRandom();
        FiniteProgress projp = LOG.isVerbose() ? new FiniteProgress("Random projections", nProject1d, LOG) : null;
        for (int j = 0; j < nProject1d; ++j) {
            int i;
            double[] currRp = new double[dim];
            double sum = 0.0;
            for (i = 0; i < dim; ++i) {
                double fl;
                currRp[i] = fl = rand.nextDouble() - 0.5;
                sum += fl * fl;
            }
            sum = Math.sqrt(sum);
            i = 0;
            while (i < dim) {
                int n = i++;
                currRp[n] = currRp[n] / sum;
            }
            WritableDoubleDataStore currPro = DataStoreUtil.makeDoubleStorage((DBIDs)ptList, (int)2);
            it = ptList.iter();
            while (it.valid()) {
                NumberVector vecPt = (NumberVector)points.get((DBIDRef)it);
                double sum2 = 0.0;
                for (int i2 = 0; i2 < dim; ++i2) {
                    sum2 += currRp[i2] * vecPt.doubleValue(i2);
                }
                currPro.put((DBIDRef)it, sum2);
                it.advance();
            }
            this.projectedPoints[j] = currPro;
            LOG.incrementProcessed((AbstractProgress)projp);
        }
        LOG.ensureCompleted(projp);
        long numprod = (long)nProject1d * (long)ptList.size();
        LOG.statistics((Statistic)new LongStatistic(PREFIX + ".num-scalar-products", numprod));
        IntArrayList proind = new IntArrayList(nProject1d);
        for (int j = 0; j < nProject1d; ++j) {
            proind.add(j);
        }
        FiniteProgress splitp = LOG.isVerbose() ? new FiniteProgress("Splitting data", nPointSetSplits, LOG) : null;
        for (int avgP = 0; avgP < nPointSetSplits; ++avgP) {
            System.arraycopy(this.projectedPoints, 0, tmpPro, 0, nProject1d);
            for (int i = 1; i < nProject1d; ++i) {
                int j = rand.nextInt(i);
                proind.set(i, proind.set(j, proind.getInt(i)));
            }
            it = proind.iterator();
            int i = 0;
            while (it.hasNext()) {
                int cind = it.nextInt();
                this.projectedPoints[cind] = tmpPro[i];
                ++i;
            }
            this.splitupNoSort(DBIDUtil.newArray((DBIDs)ptList), 0, size, 0, rand);
            LOG.incrementProcessed((AbstractProgress)splitp);
        }
        LOG.ensureCompleted(splitp);
    }

    public void splitupNoSort(ArrayModifiableDBIDs ind, int begin, int end, int dim, Random rand) {
        int nele = end - begin;
        DoubleDataStore tpro = this.projectedPoints[dim %= this.projectedPoints.length];
        if ((float)nele > (float)this.minSplitSize * 0.3333333f && (float)nele < (float)this.minSplitSize * 1.6666667f) {
            ind.sort(begin, end, (Comparator)new DataStoreUtil.AscendingByDoubleDataStore(tpro));
            this.splitsets.add((ArrayDBIDs)DBIDUtil.newArray((DBIDs)ind.slice(begin, end)));
        }
        if (nele > this.minSplitSize) {
            int minInd = this.splitRandomly(ind, begin, end, tpro, rand);
            int splitpos = minInd + 1;
            this.splitupNoSort(ind, begin, splitpos, dim + 1, rand);
            this.splitupNoSort(ind, splitpos, end, dim + 1, rand);
        }
    }

    public int splitRandomly(ArrayModifiableDBIDs ind, int begin, int end, DoubleDataStore tpro, Random rand) {
        int minInd;
        int nele = end - begin;
        DBIDArrayMIter it = ind.iter();
        double rs = tpro.doubleValue((DBIDRef)it.seek(begin + rand.nextInt(nele)));
        int maxInd = end - 1;
        for (minInd = begin; minInd < maxInd; ++minInd) {
            double currEle = tpro.doubleValue((DBIDRef)it.seek(minInd));
            if (!(currEle > rs)) continue;
            while (minInd < maxInd && tpro.doubleValue((DBIDRef)it.seek(maxInd)) > rs) {
                --maxInd;
            }
            if (minInd == maxInd) break;
            ind.swap(minInd, maxInd);
            --maxInd;
        }
        if (minInd == end - 1) {
            minInd = begin + end >>> 1;
        }
        return minInd;
    }

    public int splitByDistance(ArrayModifiableDBIDs ind, int begin, int end, DoubleDataStore tpro, Random rand) {
        DBIDArrayMIter it = ind.iter();
        double rmin = 8.988465674311579E307;
        double rmax = -8.988465674311579E307;
        int minInd = begin;
        int maxInd = end - 1;
        it.seek(begin);
        while (it.getOffset() < end) {
            double currEle = tpro.doubleValue((DBIDRef)it);
            rmin = Math.min(currEle, rmin);
            rmax = Math.max(currEle, rmax);
            it.advance();
        }
        if (rmin != rmax) {
            double rs = rmin + rand.nextDouble() * (rmax - rmin);
            while (minInd < maxInd) {
                double currEle = tpro.doubleValue((DBIDRef)it.seek(minInd));
                if (currEle > rs) {
                    while (minInd < maxInd && tpro.doubleValue((DBIDRef)it.seek(maxInd)) > rs) {
                        --maxInd;
                    }
                    if (minInd == maxInd) break;
                    ind.swap(minInd, maxInd);
                    --maxInd;
                }
                ++minInd;
            }
        } else {
            minInd = begin + end >>> 1;
        }
        return minInd;
    }

    public DataStore<DBIDs> getNeighs() {
        DBIDs ids = this.points.getDBIDs();
        WritableDataStore neighs = DataStoreUtil.makeStorage((DBIDs)ids, (int)2, ModifiableDBIDs.class);
        DBIDIter it = ids.iter();
        while (it.valid()) {
            neighs.put((DBIDRef)it, (Object)DBIDUtil.newHashSet());
            it.advance();
        }
        FiniteProgress splitp = LOG.isVerbose() ? new FiniteProgress("Processing splits for neighborhoods", this.splitsets.size(), LOG) : null;
        Iterator<ArrayDBIDs> it1 = this.splitsets.iterator();
        DBIDVar v = DBIDUtil.newVar();
        while (it1.hasNext()) {
            ArrayDBIDs pinSet = it1.next();
            int indoff = pinSet.size() >> 1;
            pinSet.assignVar(indoff, v);
            ((ModifiableDBIDs)neighs.get((DBIDRef)v)).addDBIDs((DBIDs)pinSet);
            DBIDArrayIter it2 = pinSet.iter();
            while (it2.valid()) {
                ((ModifiableDBIDs)neighs.get((DBIDRef)it2)).add((DBIDRef)v);
                it2.advance();
            }
            LOG.incrementProcessed((AbstractProgress)splitp);
        }
        LOG.ensureCompleted(splitp);
        return neighs;
    }

    public DoubleDataStore computeAverageDistInSet() {
        WritableDoubleDataStore davg = DataStoreUtil.makeDoubleStorage((DBIDs)this.points.getDBIDs(), (int)2);
        WritableIntegerDataStore nDists = DataStoreUtil.makeIntegerStorage((DBIDs)this.points.getDBIDs(), (int)3);
        FiniteProgress splitp = LOG.isVerbose() ? new FiniteProgress("Processing splits for density estimation", this.splitsets.size(), LOG) : null;
        DBIDVar v = DBIDUtil.newVar();
        for (ArrayDBIDs pinSet : this.splitsets) {
            int len = pinSet.size();
            int indoff = len >> 1;
            pinSet.assignVar(indoff, v);
            NumberVector midpoint = (NumberVector)this.points.get((DBIDRef)v);
            DBIDArrayIter it = pinSet.iter();
            while (it.getOffset() < len) {
                if (!DBIDUtil.equal((DBIDRef)it, (DBIDRef)v)) {
                    double dist = EuclideanDistance.STATIC.distance((NumberVector)this.points.get((DBIDRef)it), midpoint);
                    ++this.distanceComputations;
                    davg.increment((DBIDRef)v, dist);
                    nDists.increment((DBIDRef)v, 1);
                    davg.increment((DBIDRef)it, dist);
                    nDists.increment((DBIDRef)it, 1);
                }
                it.advance();
            }
            LOG.incrementProcessed((AbstractProgress)splitp);
        }
        LOG.ensureCompleted(splitp);
        DBIDIter it = this.points.getDBIDs().iter();
        while (it.valid()) {
            int count = nDists.intValue((DBIDRef)it);
            double val = count == 0 ? (double)-0.1f : davg.doubleValue((DBIDRef)it) / (double)count;
            davg.put((DBIDRef)it, val);
            it.advance();
        }
        nDists.destroy();
        return davg;
    }

    public void logStatistics() {
        LOG.statistics((Statistic)new LongStatistic(PREFIX + ".distance-computations", this.distanceComputations));
    }

    public static class Par
    implements Parameterizer {
        public static final OptionID RANDOM_ID = new OptionID("fastoptics.randomproj.seed", "Random seed for generating projections.");
        RandomFactory rnd;

        public void configure(Parameterization config) {
            new RandomParameter(RANDOM_ID).grab(config, x -> {
                this.rnd = x;
            });
        }

        public RandomProjectedNeighborsAndDensities make() {
            return new RandomProjectedNeighborsAndDensities(this.rnd);
        }
    }
}

