/*
 * Decompiled with CFR 0.152.
 */
package elki.index.tree.betula;

import elki.index.tree.betula.features.ClusterFeature;
import elki.utilities.exceptions.AbortException;

public class CFDistanceMatrix {
    int size;
    ClusterFeature[] cfs;
    double[] matrix;

    public CFDistanceMatrix(ClusterFeature[] cfs) {
        this.size = cfs.length;
        if (this.size > 65536) {
            throw new AbortException("This implementation does not scale to data sets larger than 65536 instances (~16 GB RAM), at which point the Java maximum array size is reached.");
        }
        this.cfs = cfs;
        this.matrix = new double[CFDistanceMatrix.triangleSize(this.size)];
    }

    public static int triangleSize(int x) {
        return x * (x - 1) >>> 1;
    }

    public double get(int x, int y) {
        return x == y ? 0.0 : (x < y ? this.matrix[CFDistanceMatrix.triangleSize(y) + x] : this.matrix[CFDistanceMatrix.triangleSize(x) + y]);
    }
}

