/*
 * Decompiled with CFR 0.152.
 */
package elki.index.tree.betula;

import elki.index.tree.betula.features.AsClusterFeature;
import elki.index.tree.betula.features.ClusterFeature;

public class CFNode<L extends ClusterFeature>
implements AsClusterFeature {
    private L cf;
    private Object[] children;

    public CFNode(L cf, int capacity) {
        this.cf = cf;
        this.children = new Object[capacity];
    }

    public L getCF() {
        return this.cf;
    }

    public void setChild(int i, AsClusterFeature cf) {
        this.children[i] = cf;
    }

    public boolean setChild(AsClusterFeature node) {
        for (int i = 0; i < this.children.length; ++i) {
            if (this.children[i] != null) continue;
            this.children[i] = node;
            return true;
        }
        return false;
    }

    public AsClusterFeature getChild(int i) {
        return i < this.children.length ? (AsClusterFeature)this.children[i] : null;
    }

    public boolean add(AsClusterFeature node) {
        for (int i = 0; i < this.children.length; ++i) {
            if (this.children[i] != null) continue;
            this.children[i] = node;
            this.cf.addToStatistics(node.getCF());
            return true;
        }
        return false;
    }

    public void add(int i, AsClusterFeature node) {
        this.children[i] = node;
        this.cf.addToStatistics(node.getCF());
    }

    public int capacity() {
        return this.children.length;
    }
}

