/*
 * Decompiled with CFR 0.152.
 */
package elki.index.tree.betula.distance;

import elki.data.NumberVector;
import elki.distance.minkowski.SquaredEuclideanDistance;
import elki.index.tree.betula.distance.CFDistance;
import elki.index.tree.betula.features.ClusterFeature;
import elki.utilities.Alias;
import elki.utilities.documentation.Reference;
import elki.utilities.documentation.References;
import elki.utilities.optionhandling.Parameterizer;

@Alias(value={"D3"})
@References(value={@Reference(authors="Andreas Lang and Erich Schubert", title="BETULA: Numerically Stable CF-Trees for BIRCH Clustering", booktitle="Int. Conf on Similarity Search and Applications", url="https://doi.org/10.1007/978-3-030-60936-8_22", bibkey="DBLP:conf/sisap/LangS20"), @Reference(authors="Andreas Lang and Erich Schubert", title="BETULA: Fast Clustering of Large Data with Improved BIRCH CF-Trees", booktitle="Information Systems", url="https://doi.org/10.1016/j.is.2021.101918", bibkey="DBLP:journals/is/LangS22")})
public class AverageIntraclusterDistance
implements CFDistance {
    public static final AverageIntraclusterDistance STATIC = new AverageIntraclusterDistance();

    @Override
    public double squaredDistance(NumberVector nv, ClusterFeature cf1) {
        return cf1.getWeight() <= 0 ? 0.0 : 2.0 * ((double)(cf1.getWeight() + 1) * cf1.sumdev() + (double)cf1.getWeight() * SquaredEuclideanDistance.STATIC.distance((NumberVector)cf1, nv)) / (double)((cf1.getWeight() + 1) * cf1.getWeight());
    }

    @Override
    public double squaredDistance(ClusterFeature cf1, ClusterFeature cf2) {
        double n12 = cf1.getWeight() + cf2.getWeight();
        return n12 <= 0.0 ? 0.0 : 2.0 * (n12 * (cf1.sumdev() + cf2.sumdev()) + (double)(cf1.getWeight() * cf2.getWeight()) * SquaredEuclideanDistance.STATIC.distance((NumberVector)cf1, (NumberVector)cf2)) / (n12 * (n12 - 1.0));
    }

    @Override
    public double matSelfInit(ClusterFeature cf) {
        return 2.0 * cf.sumdev() / (double)(cf.getWeight() - 1);
    }

    public static class Par
    implements Parameterizer {
        public AverageIntraclusterDistance make() {
            return STATIC;
        }
    }
}

