/*
 * Decompiled with CFR 0.152.
 */
package elki.index.tree.betula.distance;

import elki.data.NumberVector;
import elki.index.tree.betula.distance.CFDistance;
import elki.index.tree.betula.features.BIRCHCF;
import elki.index.tree.betula.features.ClusterFeature;
import elki.utilities.Priority;
import elki.utilities.documentation.Reference;
import elki.utilities.optionhandling.Parameterizer;

@Priority(value=-100)
@Reference(authors="T. Zhang", title="Data Clustering for Very Large Datasets Plus Applications", booktitle="University of Wisconsin Madison, Technical Report #1355", url="ftp://ftp.cs.wisc.edu/pub/techreports/1997/TR1355.pdf", bibkey="tr/wisc/Zhang97")
public class BIRCHAverageInterclusterDistance
implements CFDistance {
    public static final BIRCHAverageInterclusterDistance STATIC = new BIRCHAverageInterclusterDistance();

    @Override
    public double squaredDistance(NumberVector v, ClusterFeature ocf) {
        if (!(ocf instanceof BIRCHCF)) {
            throw new IllegalStateException("This distance only supports BIRCH clustering features.");
        }
        BIRCHCF cf = (BIRCHCF)ocf;
        int dim = v.getDimensionality();
        assert (dim == cf.getDimensionality());
        double sum = 0.0;
        for (int d = 0; d < dim; ++d) {
            sum += v.doubleValue(d) * cf.ls(d);
        }
        sum = cf.sumdev() + (double)cf.getWeight() * BIRCHCF.sumOfSquares(v) - 2.0 * sum;
        return sum > 0.0 ? sum / (double)cf.getWeight() : 0.0;
    }

    @Override
    public double squaredDistance(ClusterFeature ocf1, ClusterFeature ocf2) {
        if (!(ocf1 instanceof BIRCHCF) || !(ocf2 instanceof BIRCHCF)) {
            throw new IllegalStateException("This distance only supports BIRCH clustering features.");
        }
        BIRCHCF cf1 = (BIRCHCF)ocf1;
        BIRCHCF cf2 = (BIRCHCF)ocf2;
        int dim = cf1.getDimensionality();
        assert (dim == cf2.getDimensionality());
        double sum = 0.0;
        for (int d = 0; d < dim; ++d) {
            sum += cf1.ls(d) * cf2.ls(d);
        }
        sum = (double)cf2.getWeight() * cf1.sumOfSumOfSquares() + (double)cf1.getWeight() * cf2.sumOfSumOfSquares() - 2.0 * sum;
        return sum > 0.0 ? sum / (double)((long)cf1.getWeight() * (long)cf2.getWeight()) : 0.0;
    }

    public static class Par
    implements Parameterizer {
        public BIRCHAverageInterclusterDistance make() {
            return STATIC;
        }
    }
}

