/*
 * Decompiled with CFR 0.152.
 */
package elki.index.tree.betula.distance;

import elki.data.NumberVector;
import elki.index.tree.betula.distance.CFDistance;
import elki.index.tree.betula.features.BIRCHCF;
import elki.index.tree.betula.features.ClusterFeature;
import elki.utilities.Priority;
import elki.utilities.documentation.Reference;
import elki.utilities.optionhandling.Parameterizer;

@Priority(value=-100)
@Reference(authors="T. Zhang", title="Data Clustering for Very Large Datasets Plus Applications", booktitle="University of Wisconsin Madison, Technical Report #1355", url="ftp://ftp.cs.wisc.edu/pub/techreports/1997/TR1355.pdf", bibkey="tr/wisc/Zhang97")
public class BIRCHAverageIntraclusterDistance
implements CFDistance {
    public static final BIRCHAverageIntraclusterDistance STATIC = new BIRCHAverageIntraclusterDistance();

    @Override
    public double squaredDistance(NumberVector v, ClusterFeature ocf) {
        if (!(ocf instanceof BIRCHCF)) {
            throw new IllegalStateException("This distance only supports BIRCH clustering features.");
        }
        BIRCHCF cf = (BIRCHCF)ocf;
        int dim = v.getDimensionality();
        assert (dim == cf.getDimensionality());
        double div1 = 1.0 / (double)(1 + cf.getWeight());
        double div2 = 1.0 / (double)cf.getWeight();
        double sum = (cf.sumOfSumOfSquares() + BIRCHCF.sumOfSquares(v)) * div2;
        for (int d = 0; d < dim; ++d) {
            double x = cf.ls(d) + v.doubleValue(d);
            sum -= x * div1 * (x * div2);
        }
        return sum > 0.0 ? sum * 2.0 : 0.0;
    }

    @Override
    public double squaredDistance(ClusterFeature ocf1, ClusterFeature ocf2) {
        if (!(ocf1 instanceof BIRCHCF) || !(ocf2 instanceof BIRCHCF)) {
            throw new IllegalStateException("This distance only supports BIRCH clustering features.");
        }
        BIRCHCF cf1 = (BIRCHCF)ocf1;
        BIRCHCF cf2 = (BIRCHCF)ocf2;
        int dim = cf1.getDimensionality();
        assert (dim == cf2.getDimensionality());
        int n12 = cf1.getWeight() + cf2.getWeight();
        double div1 = 1.0 / (double)n12;
        double div2 = 1.0 / (double)(n12 - 1);
        double sum = (cf1.sumOfSumOfSquares() + cf2.sumOfSumOfSquares()) * div2;
        for (int d = 0; d < dim; ++d) {
            double x = cf1.ls(d) + cf2.ls(d);
            sum -= x * div1 * (x * div2);
        }
        return sum > 0.0 ? sum * 2.0 : 0.0;
    }

    public static class Par
    implements Parameterizer {
        public BIRCHAverageIntraclusterDistance make() {
            return STATIC;
        }
    }
}

