/*
 * Decompiled with CFR 0.152.
 */
package elki.index.tree.betula.distance;

import elki.data.NumberVector;
import elki.index.tree.betula.distance.CFDistance;
import elki.index.tree.betula.features.BIRCHCF;
import elki.index.tree.betula.features.ClusterFeature;
import elki.utilities.Priority;
import elki.utilities.documentation.Reference;
import elki.utilities.optionhandling.Parameterizer;

@Priority(value=-100)
@Reference(authors="T. Zhang, R. Ramakrishnan, M. Livny", title="BIRCH: An Efficient Data Clustering Method for Very Large Databases", booktitle="Proc. 1996 ACM SIGMOD International Conference on Management of Data", url="https://doi.org/10.1145/233269.233324", bibkey="DBLP:conf/sigmod/ZhangRL96")
public class BIRCHRadiusDistance
implements CFDistance {
    public static final BIRCHRadiusDistance STATIC = new BIRCHRadiusDistance();

    @Override
    public double squaredDistance(NumberVector n, ClusterFeature ocf) {
        double v;
        int d;
        if (!(ocf instanceof BIRCHCF)) {
            throw new IllegalStateException("This distance only supports BIRCH clustering features.");
        }
        BIRCHCF cf = (BIRCHCF)ocf;
        if (cf.getWeight() <= 0) {
            return 0.0;
        }
        int dim = cf.getDimensionality();
        double div = 1.0 / (double)(cf.getWeight() + 1);
        double sum = cf.sumOfSumOfSquares();
        for (d = 0; d < dim; ++d) {
            v = n.doubleValue(d);
            sum += v * v;
        }
        sum *= div;
        for (d = 0; d < dim; ++d) {
            v = (cf.ls(d) + n.doubleValue(d)) * div;
            sum -= v * v;
        }
        return sum > 0.0 ? sum : 0.0;
    }

    @Override
    public double squaredDistance(ClusterFeature ocf1, ClusterFeature ocf2) {
        if (!(ocf1 instanceof BIRCHCF) || !(ocf2 instanceof BIRCHCF)) {
            throw new IllegalStateException("This distance only supports BIRCH clustering features.");
        }
        BIRCHCF cf1 = (BIRCHCF)ocf1;
        BIRCHCF cf2 = (BIRCHCF)ocf2;
        int n12 = cf1.getWeight() + cf2.getWeight();
        if (n12 <= 1) {
            return 0.0;
        }
        int dim = cf1.getDimensionality();
        double div = 1.0 / (double)n12;
        double sum = (cf1.sumOfSumOfSquares() + cf2.sumOfSumOfSquares()) * div;
        for (int i = 0; i < dim; ++i) {
            double v = (cf1.ls(i) + cf2.ls(i)) * div;
            sum -= v * v;
        }
        return sum > 0.0 ? sum : 0.0;
    }

    public static class Par
    implements Parameterizer {
        public BIRCHRadiusDistance make() {
            return STATIC;
        }
    }
}

