/*
 * Decompiled with CFR 0.152.
 */
package elki.index.tree.betula.distance;

import elki.data.NumberVector;
import elki.index.tree.betula.distance.CFDistance;
import elki.index.tree.betula.features.BIRCHCF;
import elki.index.tree.betula.features.ClusterFeature;
import elki.utilities.Priority;
import elki.utilities.documentation.Reference;
import elki.utilities.optionhandling.Parameterizer;

@Priority(value=-100)
@Reference(authors="T. Zhang", title="Data Clustering for Very Large Datasets Plus Applications", booktitle="University of Wisconsin Madison, Technical Report #1355", url="ftp://ftp.cs.wisc.edu/pub/techreports/1997/TR1355.pdf", bibkey="tr/wisc/Zhang97")
public class BIRCHVarianceIncreaseDistance
implements CFDistance {
    public static final BIRCHVarianceIncreaseDistance STATIC = new BIRCHVarianceIncreaseDistance();

    @Override
    public double squaredDistance(NumberVector v, ClusterFeature ocf) {
        if (!(ocf instanceof BIRCHCF)) {
            throw new IllegalStateException("This distance only supports BIRCH clustering features.");
        }
        BIRCHCF cf = (BIRCHCF)ocf;
        int dim = v.getDimensionality();
        assert (dim == cf.getDimensionality());
        int n2 = cf.getWeight();
        int n3 = 1 + n2;
        double div2 = 1.0 / (double)n2;
        double div3 = 1.0 / (double)n3;
        double dot1 = 0.0;
        double dot2 = 0.0;
        double dot3 = 0.0;
        for (int d = 0; d < dim; ++d) {
            double x1 = v.doubleValue(d);
            double x2 = cf.ls(d);
            double x3 = (x1 + x2) * div3;
            dot1 += x1 * x1;
            dot2 += (x2 *= div2) * x2;
            dot3 += x3 * x3;
        }
        double sum = dot1 + (double)n2 * dot2 - (double)n3 * dot3;
        return sum > 0.0 ? sum : 0.0;
    }

    @Override
    public double squaredDistance(ClusterFeature ocf1, ClusterFeature ocf2) {
        if (!(ocf1 instanceof BIRCHCF) || !(ocf2 instanceof BIRCHCF)) {
            throw new IllegalStateException("This distance only supports BIRCH clustering features.");
        }
        BIRCHCF cf1 = (BIRCHCF)ocf1;
        BIRCHCF cf2 = (BIRCHCF)ocf2;
        int dim = cf1.getDimensionality();
        assert (dim == cf2.getDimensionality());
        int n1 = cf1.getWeight();
        int n2 = cf2.getWeight();
        int n3 = n1 + n2;
        double div1 = 1.0 / (double)n1;
        double div2 = 1.0 / (double)n2;
        double div3 = 1.0 / (double)n3;
        double dot1 = 0.0;
        double dot2 = 0.0;
        double dot3 = 0.0;
        for (int d = 0; d < dim; ++d) {
            double x1 = cf1.ls(d);
            double x2 = cf2.ls(d);
            double x3 = (x1 + x2) * div3;
            dot1 += (x1 *= div1) * x1;
            dot2 += (x2 *= div2) * x2;
            dot3 += x3 * x3;
        }
        double sum = (double)n1 * dot1 + (double)n2 * dot2 - (double)n3 * dot3;
        return sum > 0.0 ? sum : 0.0;
    }

    public static class Par
    implements Parameterizer {
        public BIRCHVarianceIncreaseDistance make() {
            return STATIC;
        }
    }
}

