/*
 * Decompiled with CFR 0.152.
 */
package elki.index.tree.betula.distance;

import elki.data.NumberVector;
import elki.distance.minkowski.SquaredEuclideanDistance;
import elki.index.tree.betula.distance.CFDistance;
import elki.index.tree.betula.features.ClusterFeature;
import elki.utilities.Alias;
import elki.utilities.documentation.Reference;
import elki.utilities.documentation.References;
import elki.utilities.optionhandling.Parameterizer;

@Alias(value={"D4"})
@References(value={@Reference(authors="Andreas Lang and Erich Schubert", title="BETULA: Numerically Stable CF-Trees for BIRCH Clustering", booktitle="Int. Conf on Similarity Search and Applications", url="https://doi.org/10.1007/978-3-030-60936-8_22", bibkey="DBLP:conf/sisap/LangS20"), @Reference(authors="Andreas Lang and Erich Schubert", title="BETULA: Fast Clustering of Large Data with Improved BIRCH CF-Trees", booktitle="Information Systems", url="https://doi.org/10.1016/j.is.2021.101918", bibkey="DBLP:journals/is/LangS22")})
public class VarianceIncreaseDistance
implements CFDistance {
    public static final VarianceIncreaseDistance STATIC = new VarianceIncreaseDistance();

    @Override
    public double squaredDistance(NumberVector nv, ClusterFeature cf) {
        return SquaredEuclideanDistance.STATIC.distance((NumberVector)cf, nv) * (double)cf.getWeight() / (double)(cf.getWeight() + 1);
    }

    @Override
    public double squaredDistance(ClusterFeature cf1, ClusterFeature cf2) {
        return SquaredEuclideanDistance.STATIC.distance((NumberVector)cf1, (NumberVector)cf2) * (double)cf1.getWeight() * (double)cf2.getWeight() / (double)(cf1.getWeight() + cf2.getWeight());
    }

    public static class Par
    implements Parameterizer {
        public VarianceIncreaseDistance make() {
            return STATIC;
        }
    }
}

