/*
 * Decompiled with CFR 0.152.
 */
package elki.index.tree.betula.features;

import elki.data.NumberVector;
import elki.index.tree.betula.features.ClusterFeature;
import elki.math.linearalgebra.VMath;
import elki.utilities.Priority;
import elki.utilities.optionhandling.Parameterizer;
import java.util.Arrays;

public class BIRCHCF
implements ClusterFeature {
    int n = 0;
    double[] ls;
    double ss;

    public BIRCHCF(int dimensionality) {
        this.ls = new double[dimensionality];
    }

    @Override
    public void addToStatistics(NumberVector nv) {
        int d = nv.getDimensionality();
        assert (d == this.ls.length);
        ++this.n;
        int i = 0;
        while (i < d) {
            double v = nv.doubleValue(i);
            int n = i++;
            this.ls[n] = this.ls[n] + v;
            this.ss += v * v;
        }
    }

    @Override
    public void addToStatistics(ClusterFeature other) {
        this.addToStatistics((BIRCHCF)other);
    }

    public void addToStatistics(BIRCHCF other) {
        this.n += other.n;
        VMath.plusEquals((double[])this.ls, (double[])other.ls);
        this.ss += other.ss;
    }

    @Override
    public void resetStatistics() {
        this.n = 0;
        Arrays.fill(this.ls, 0.0);
        this.ss = 0.0;
    }

    @Override
    public double centroid(int i) {
        return this.n > 0 ? this.ls[i] / (double)this.n : 0.0;
    }

    public double sumOfSumOfSquares() {
        return this.ss;
    }

    public double sumOfSquaresOfSums() {
        double sum = 0.0;
        for (int i = 0; i < this.ls.length; ++i) {
            double v = this.ls[i];
            sum += v * v;
        }
        return sum;
    }

    public int getDimensionality() {
        return this.ls.length;
    }

    public static double sumOfSquares(NumberVector v) {
        int dim = v.getDimensionality();
        double sum = 0.0;
        for (int d = 0; d < dim; ++d) {
            double x = v.doubleValue(d);
            sum += x * x;
        }
        return sum;
    }

    public double ls(int i) {
        return this.ls[i];
    }

    @Override
    public double variance(int i) {
        double v = this.variance();
        return v >= 0.0 ? v / (double)this.ls.length : 0.0;
    }

    @Override
    public int getWeight() {
        return this.n;
    }

    @Override
    public double variance() {
        double v = this.ss / (double)this.n;
        for (int d = 0; d < this.ls.length; ++d) {
            double s = this.ls[d] / (double)this.n;
            v -= s * s;
        }
        return v >= 0.0 ? v : 0.0;
    }

    @Override
    public double sumdev() {
        double v = this.ss;
        for (int d = 0; d < this.ls.length; ++d) {
            double s = this.ls[d];
            v -= s * s / (double)this.n;
        }
        return v;
    }

    @Override
    public double[][] covariance() {
        throw new IllegalStateException("This CF Model doesn't support this method.");
    }

    public double[] toArray() {
        return VMath.times((double[])this.ls, (double)(1.0 / (double)this.n));
    }

    @Priority(value=-100)
    public static class Factory
    implements ClusterFeature.Factory<BIRCHCF> {
        public static final Factory STATIC = new Factory();

        @Override
        public BIRCHCF make(int dim) {
            return new BIRCHCF(dim);
        }

        public static class Par
        implements Parameterizer {
            public Factory make() {
                return STATIC;
            }
        }
    }
}

