/*
 * Decompiled with CFR 0.152.
 */
package elki.index.tree.betula.features;

import elki.data.NumberVector;
import elki.index.tree.betula.features.ClusterFeature;
import elki.utilities.Alias;
import elki.utilities.optionhandling.Parameterizer;
import java.util.Arrays;

public class VIIFeature
implements ClusterFeature {
    int n = 0;
    double[] mean;
    double ssd;

    public VIIFeature(int dimensionality) {
        this.mean = new double[dimensionality];
    }

    @Override
    public void addToStatistics(NumberVector nv) {
        int d = nv.getDimensionality();
        assert (d == this.mean.length);
        if (this.n == 0) {
            for (int i = 0; i < d; ++i) {
                this.mean[i] = nv.doubleValue(i);
            }
            this.ssd = 0.0;
            ++this.n;
            return;
        }
        int i = 0;
        while (i < d) {
            double v = nv.doubleValue(i);
            double delta = v - this.mean[i];
            int n = i++;
            double d2 = this.mean[n] + delta / ((double)this.n + 1.0);
            this.mean[n] = d2;
            double newmean = d2;
            this.ssd += delta * (v - newmean);
        }
        ++this.n;
    }

    @Override
    public void addToStatistics(ClusterFeature other) {
        this.addToStatistics((VIIFeature)other);
    }

    public void addToStatistics(VIIFeature other) {
        if (this.n == 0) {
            for (int i = 0; i < this.mean.length; ++i) {
                this.mean[i] = other.mean[i];
            }
            this.ssd = other.ssd;
            this.n = other.n;
            return;
        }
        assert (this.n > 0 && other.n > 0);
        double factor = (double)other.n / (double)(this.n + other.n);
        double ssinc = 0.0;
        for (int i = 0; i < this.mean.length; ++i) {
            double delta = other.mean[i] - this.mean[i];
            int n = i;
            double d = this.mean[n] + delta * factor;
            this.mean[n] = d;
            double newmean = d;
            ssinc += (double)other.n * (delta * (other.mean[i] - newmean));
        }
        this.ssd += other.ssd + ssinc;
        this.n += other.n;
    }

    @Override
    public void resetStatistics() {
        this.n = 0;
        this.ssd = 0.0;
        Arrays.fill(this.mean, 0.0);
    }

    @Override
    public double centroid(int i) {
        return this.mean[i];
    }

    @Override
    public double variance() {
        return this.ssd / (double)this.n;
    }

    @Override
    public double sumdev() {
        return this.ssd;
    }

    @Override
    public double variance(int d) {
        double var = this.ssd / (double)(this.mean.length * this.n);
        return var >= 0.0 ? var : 0.0;
    }

    @Override
    public double[][] covariance() {
        throw new IllegalStateException("This CF Model doesn't support this method.");
    }

    public double sumOfSquaredDev() {
        return this.ssd;
    }

    public int getDimensionality() {
        return this.mean.length;
    }

    @Override
    public int getWeight() {
        return this.n;
    }

    public double[] toArray() {
        return (double[])this.mean.clone();
    }

    @Alias(value={"VII"})
    public static class Factory
    implements ClusterFeature.Factory<VIIFeature> {
        public static final Factory STATIC = new Factory();

        @Override
        public VIIFeature make(int dim) {
            return new VIIFeature(dim);
        }

        public static class Par
        implements Parameterizer {
            public Factory make() {
                return STATIC;
            }
        }
    }
}

