/*
 * Decompiled with CFR 0.152.
 */
package elki.index.tree.betula.features;

import elki.data.NumberVector;
import elki.index.tree.betula.features.ClusterFeature;
import elki.utilities.Alias;
import elki.utilities.optionhandling.Parameterizer;
import java.util.Arrays;

public class VVIFeature
implements ClusterFeature {
    int n = 0;
    double[] mean;
    double[] ssd;

    public VVIFeature(int dimensionality) {
        this.ssd = new double[dimensionality];
        this.mean = new double[dimensionality];
    }

    @Override
    public void addToStatistics(NumberVector nv) {
        int d = nv.getDimensionality();
        assert (d == this.ssd.length);
        if (this.n == 0) {
            for (int i = 0; i < d; ++i) {
                this.ssd[i] = 0.0;
                this.mean[i] = nv.doubleValue(i);
            }
            ++this.n;
            return;
        }
        int i = 0;
        while (i < d) {
            double v = nv.doubleValue(i);
            double delta = v - this.mean[i];
            int n = i;
            double d2 = this.mean[n] + delta / ((double)this.n + 1.0);
            this.mean[n] = d2;
            double newmean = d2;
            int n2 = i++;
            this.ssd[n2] = this.ssd[n2] + delta * (v - newmean);
        }
        ++this.n;
    }

    @Override
    public void addToStatistics(ClusterFeature other) {
        this.addToStatistics((VVIFeature)other);
    }

    public void addToStatistics(VVIFeature other) {
        if (this.n == 0) {
            for (int i = 0; i < this.ssd.length; ++i) {
                this.ssd[i] = other.ssd[i];
                this.mean[i] = other.mean[i];
            }
            this.n = other.n;
            return;
        }
        assert (this.n > 0 && other.n > 0);
        double factor = (double)other.n / (double)(this.n + other.n);
        for (int i = 0; i < this.ssd.length; ++i) {
            double delta = other.mean[i] - this.mean[i];
            int n = i;
            double d = this.mean[n] + delta * factor;
            this.mean[n] = d;
            double newmean = d;
            int n2 = i;
            this.ssd[n2] = this.ssd[n2] + (other.ssd[i] + (double)other.n * (delta * (other.mean[i] - newmean)));
        }
        this.n += other.n;
    }

    @Override
    public void resetStatistics() {
        this.n = 0;
        Arrays.fill(this.ssd, 0.0);
        Arrays.fill(this.mean, 0.0);
    }

    @Override
    public double centroid(int i) {
        return this.mean[i];
    }

    @Override
    public double variance() {
        double var = 0.0;
        for (int i = 0; i < this.ssd.length; ++i) {
            var += this.ssd[i];
        }
        return var / (double)this.n;
    }

    @Override
    public double sumdev() {
        double var = 0.0;
        for (int i = 0; i < this.ssd.length; ++i) {
            var += this.ssd[i];
        }
        return var;
    }

    @Override
    public double variance(int d) {
        double var = this.ssd[d] / (double)this.n;
        return var >= 0.0 ? var : 0.0;
    }

    @Override
    public double[][] covariance() {
        throw new IllegalStateException("This CF Model doesn't support this method.");
    }

    public double sumOfSquaredDev(int i) {
        return this.ssd[i];
    }

    public int getDimensionality() {
        return this.ssd.length;
    }

    @Override
    public int getWeight() {
        return this.n;
    }

    public double[] toArray() {
        return (double[])this.mean.clone();
    }

    @Alias(value={"VVI"})
    public static class Factory
    implements ClusterFeature.Factory<VVIFeature> {
        public static final Factory STATIC = new Factory();

        @Override
        public VVIFeature make(int dim) {
            return new VVIFeature(dim);
        }

        public static class Par
        implements Parameterizer {
            public Factory make() {
                return STATIC;
            }
        }
    }
}

