/*
 * Decompiled with CFR 0.152.
 */
package elki.index.tree.betula.features;

import elki.data.NumberVector;
import elki.index.tree.betula.features.ClusterFeature;
import elki.utilities.Alias;
import elki.utilities.optionhandling.Parameterizer;
import java.util.Arrays;

public class VVVFeature
implements ClusterFeature {
    int n = 0;
    double[] mean;
    double[][] ssd;

    public VVVFeature(int dimensionality) {
        this.ssd = new double[dimensionality][dimensionality];
        this.mean = new double[dimensionality];
    }

    @Override
    public void addToStatistics(NumberVector nv) {
        int i;
        int d = nv.getDimensionality();
        assert (d == this.ssd.length);
        if (this.n == 0) {
            for (int i2 = 0; i2 < d; ++i2) {
                for (int j = 0; j < d; ++j) {
                    this.ssd[i2][j] = 0.0;
                }
                this.mean[i2] = nv.doubleValue(i2);
            }
            ++this.n;
            return;
        }
        double[] nmea = new double[d];
        double f = 1.0 / ((double)this.n + 1.0);
        for (i = 0; i < d; ++i) {
            double vi = nv.doubleValue(i);
            double delta = vi - this.mean[i];
            nmea[i] = this.mean[i] + delta * f;
            for (int j = 0; j <= i; ++j) {
                double[] dArray = this.ssd[i];
                int n = j;
                dArray[n] = dArray[n] + delta * (nv.doubleValue(j) - nmea[j]);
            }
        }
        for (i = 0; i < d; ++i) {
            for (int j = 0; j < i; ++j) {
                this.ssd[j][i] = this.ssd[i][j];
            }
        }
        ++this.n;
        System.arraycopy(nmea, 0, this.mean, 0, nmea.length);
    }

    @Override
    public void addToStatistics(ClusterFeature other) {
        this.addToStatistics((VVVFeature)other);
    }

    public void addToStatistics(VVVFeature other) {
        int i;
        if (this.n == 0) {
            for (int i2 = 0; i2 < this.ssd.length; ++i2) {
                for (int j = 0; j < this.ssd.length; ++j) {
                    this.ssd[i2][j] = other.ssd[i2][j];
                }
                this.mean[i2] = other.mean[i2];
            }
            this.n = other.n;
            return;
        }
        assert (this.n > 0 && other.n > 0);
        double[] nmea = new double[this.mean.length];
        double factor = (double)other.n / (double)(this.n + other.n);
        for (i = 0; i < this.ssd.length; ++i) {
            double delta = other.mean[i] - this.mean[i];
            nmea[i] = this.mean[i] + delta * factor;
            for (int j = 0; j <= i; ++j) {
                double[] dArray = this.ssd[i];
                int n = j;
                dArray[n] = dArray[n] + (other.ssd[i][j] + (double)other.n * (delta * (other.mean[j] - nmea[j])));
            }
        }
        for (i = 0; i < this.ssd.length; ++i) {
            for (int j = 0; j < i; ++j) {
                this.ssd[j][i] = this.ssd[i][j];
            }
        }
        this.n += other.n;
        System.arraycopy(nmea, 0, this.mean, 0, nmea.length);
    }

    @Override
    public void resetStatistics() {
        this.n = 0;
        for (int i = 0; i < this.ssd.length; ++i) {
            Arrays.fill(this.ssd[i], 0.0);
        }
        Arrays.fill(this.mean, 0.0);
    }

    @Override
    public double centroid(int i) {
        return this.mean[i];
    }

    @Override
    public double variance() {
        double var = 0.0;
        for (int i = 0; i < this.ssd.length; ++i) {
            var += this.ssd[i][i];
        }
        return var / (double)this.n;
    }

    @Override
    public double sumdev() {
        double var = 0.0;
        for (int i = 0; i < this.ssd.length; ++i) {
            var += this.ssd[i][i];
        }
        return var;
    }

    @Override
    public double variance(int d) {
        double var = this.ssd[d][d] / (double)this.n;
        return var >= 0.0 ? var : 0.0;
    }

    @Override
    public double[][] covariance() {
        double[][] cov = new double[this.mean.length][this.mean.length];
        double f = 1.0 / (double)this.n;
        for (int i = 0; i < this.mean.length; ++i) {
            for (int j = 0; j < this.mean.length; ++j) {
                cov[i][j] = this.ssd[i][j] * f;
            }
        }
        return cov;
    }

    public int getDimensionality() {
        return this.mean.length;
    }

    @Override
    public int getWeight() {
        return this.n;
    }

    public double[] toArray() {
        return (double[])this.mean.clone();
    }

    @Alias(value={"VVV"})
    public static class Factory
    implements ClusterFeature.Factory<VVVFeature> {
        public static final Factory STATIC = new Factory();

        @Override
        public VVVFeature make(int dim) {
            return new VVVFeature(dim);
        }

        public static class Par
        implements Parameterizer {
            public Factory make() {
                return STATIC;
            }
        }
    }
}

