/*
 * Decompiled with CFR 0.152.
 */
package elki.result;

import elki.data.Cluster;
import elki.data.Clustering;
import elki.data.model.Model;
import elki.data.type.TypeInformation;
import elki.data.type.TypeUtil;
import elki.database.Database;
import elki.database.datastore.DataStoreUtil;
import elki.database.datastore.WritableIntegerDataStore;
import elki.database.ids.DBIDArrayIter;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRange;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDs;
import elki.database.relation.Relation;
import elki.logging.Logging;
import elki.result.Metadata;
import elki.result.ResultHandler;
import elki.utilities.datastructures.iterator.It;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.FileParameter;
import elki.utilities.optionhandling.parameters.Flag;
import elki.utilities.optionhandling.parameters.StringParameter;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.List;

public class ClusteringVectorDumper
implements ResultHandler {
    private static final Logging LOG = Logging.getLogger(ClusteringVectorDumper.class);
    private Path outputFile;
    private String forceLabel;
    private boolean append;

    public ClusteringVectorDumper(Path outputFile, boolean append, String forceLabel) {
        this.outputFile = outputFile;
        this.forceLabel = forceLabel;
        this.append = append;
    }

    public ClusteringVectorDumper(Path outputFile, boolean append) {
        this(outputFile, append, null);
    }

    public void processNewResult(Object newResult) {
        List<Clustering<Model>> cs = Clustering.getClusteringResults(newResult);
        if (cs.isEmpty()) {
            return;
        }
        if (this.forceLabel != null && this.forceLabel.length() > 0 && cs.size() > 1) {
            LOG.warning((CharSequence)"Found more than one clustering result, they will have the same (forced) label.");
        }
        if (this.outputFile != null) {
            StandardOpenOption opt = this.append ? StandardOpenOption.APPEND : StandardOpenOption.TRUNCATE_EXISTING;
            try (BufferedWriter writer = Files.newBufferedWriter(this.outputFile, opt);){
                for (Clustering<Model> c : cs) {
                    this.dumpClusteringOutput(writer, c);
                }
                this.append = true;
            }
            catch (IOException e) {
                LOG.exception((CharSequence)"Error writing to output stream.", (Throwable)e);
            }
        } else {
            for (Clustering<Model> c : cs) {
                try {
                    this.dumpClusteringOutput(System.out, c);
                }
                catch (IOException e) {
                    LOG.exception((CharSequence)"Error writing to output stream.", (Throwable)e);
                }
            }
        }
    }

    protected void dumpClusteringOutput(Appendable writer, Clustering<?> c) throws IOException {
        DBIDs pids;
        DBIDRange ids = null;
        It iter = Metadata.hierarchyOf(c).iterParents().filter(Relation.class);
        while (iter.valid()) {
            pids = ((Relation)iter.get()).getDBIDs();
            if (pids instanceof DBIDRange) {
                ids = (DBIDRange)pids;
                break;
            }
            LOG.warning((CharSequence)("Parent result " + Metadata.of((Object)iter.get()).getLongName() + " has DBID type " + pids.getClass()));
            iter.advance();
        }
        if (ids == null) {
            iter = Metadata.hierarchyOf(c).iterAncestors().filter(Database.class);
            while (iter.valid()) {
                pids = ((Database)iter.get()).getRelation((TypeInformation)TypeUtil.ANY, new Object[0]).getDBIDs();
                if (pids instanceof DBIDRange) {
                    ids = (DBIDRange)pids;
                    break;
                }
                LOG.warning((CharSequence)("Parent result " + Metadata.of((Object)iter.get()).getLongName() + " has DBID type " + pids.getClass()));
                iter.advance();
            }
        }
        if (ids == null) {
            LOG.warning((CharSequence)"Cannot dump cluster assignment, as I do not have a well-defined DBIDRange to use for a unique column assignment. DBIDs must be a continuous range.");
            return;
        }
        WritableIntegerDataStore map = DataStoreUtil.makeIntegerStorage(ids, (int)1);
        int cnum = 0;
        for (Cluster<?> clu : c.getAllClusters()) {
            DBIDIter iter2 = clu.getIDs().iter();
            while (iter2.valid()) {
                map.putInt((DBIDRef)iter2, cnum);
                iter2.advance();
            }
            ++cnum;
        }
        DBIDArrayIter iter3 = ids.iter();
        while (iter3.valid()) {
            if (iter3.getOffset() > 0) {
                writer.append(' ');
            }
            writer.append(Integer.toString(map.intValue((DBIDRef)iter3)));
            iter3.advance();
        }
        if (this.forceLabel != null) {
            if (this.forceLabel.length() > 0) {
                writer.append(' ').append(this.forceLabel);
            }
        } else {
            writer.append(' ').append(Metadata.of(c).getLongName());
        }
        writer.append('\n');
    }

    public static class Par
    implements Parameterizer {
        public static final OptionID OUT_ID = new OptionID("clustering.output", "Output file name. When not given, the result will be written to stdout.");
        public static final OptionID APPEND_ID = new OptionID("clustering.output.append", "Always append to the output file.");
        public static final OptionID FORCE_LABEL_ID = new OptionID("clustering.label", "Parameter to override the clustering label, mostly to give a more descriptive label.");
        private Path outputFile;
        private String forceLabel;
        private boolean append;

        public void configure(Parameterization config) {
            ((FileParameter)new FileParameter(OUT_ID, FileParameter.FileType.OUTPUT_FILE).setOptional(true)).grab(config, x -> {
                this.outputFile = Paths.get(x);
            });
            new Flag(APPEND_ID).grab(config, x -> {
                this.append = x;
            });
            ((StringParameter)new StringParameter(FORCE_LABEL_ID).setOptional(true)).grab(config, x -> {
                this.forceLabel = x;
            });
        }

        public ClusteringVectorDumper make() {
            return new ClusteringVectorDumper(this.outputFile, this.append, this.forceLabel);
        }
    }
}

