/*
 * Decompiled with CFR 0.152.
 */
package elki.similarity.cluster;

import elki.data.Cluster;
import elki.data.type.SimpleTypeInformation;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDs;
import elki.database.query.DistanceSimilarityQuery;
import elki.database.query.distance.PrimitiveDistanceSimilarityQuery;
import elki.database.relation.Relation;
import elki.distance.PrimitiveDistance;
import elki.similarity.PrimitiveSimilarity;
import elki.utilities.optionhandling.Parameterizer;

public class ClusterIntersectionSimilarity
implements PrimitiveDistance<Cluster<?>>,
PrimitiveSimilarity<Cluster<?>> {
    public static final ClusterIntersectionSimilarity STATIC = new ClusterIntersectionSimilarity();

    public double similarity(Cluster<?> o1, Cluster<?> o2) {
        return DBIDUtil.intersectionSize((DBIDs)o1.getIDs(), (DBIDs)o2.getIDs());
    }

    public double distance(Cluster<?> o1, Cluster<?> o2) {
        return (double)Math.max(o1.size(), o2.size()) - (double)DBIDUtil.intersectionSize((DBIDs)o1.getIDs(), (DBIDs)o2.getIDs());
    }

    public boolean isSymmetric() {
        return true;
    }

    public boolean isMetric() {
        return false;
    }

    public <T extends Cluster<?>> DistanceSimilarityQuery<T> instantiate(Relation<T> relation) {
        return new PrimitiveDistanceSimilarityQuery(relation, (PrimitiveDistance)this, (PrimitiveSimilarity)this);
    }

    public SimpleTypeInformation<? super Cluster<?>> getInputTypeRestriction() {
        return new SimpleTypeInformation(Cluster.class);
    }

    public static class Par
    implements Parameterizer {
        public ClusterIntersectionSimilarity make() {
            return STATIC;
        }
    }
}

