/*
 * Decompiled with CFR 0.152.
 */
package elki.similarity.cluster;

import elki.data.Cluster;
import elki.data.type.SimpleTypeInformation;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDs;
import elki.database.query.DistanceSimilarityQuery;
import elki.database.query.distance.PrimitiveDistanceSimilarityQuery;
import elki.database.relation.Relation;
import elki.distance.PrimitiveDistance;
import elki.similarity.PrimitiveSimilarity;
import elki.utilities.documentation.Reference;
import elki.utilities.optionhandling.Parameterizer;

@Reference(authors="P. Jaccard", title="Distribution de la florine alpine dans la Bassin de Dranses et dans quelques regiones voisines", booktitle="Bulletin del la Soci\u00e9t\u00e9 Vaudoise des Sciences Naturelles", url="http://data.rero.ch/01-R241574160", bibkey="journals/misc/Jaccard1902")
public class ClusterJaccardSimilarity
implements PrimitiveDistance<Cluster<?>>,
PrimitiveSimilarity<Cluster<?>> {
    public static final ClusterJaccardSimilarity STATIC = new ClusterJaccardSimilarity();

    public double similarity(Cluster<?> o1, Cluster<?> o2) {
        int i = DBIDUtil.intersectionSize((DBIDs)o1.getIDs(), (DBIDs)o2.getIDs());
        int union = o1.size() + o2.size() - i;
        return (double)i / (double)union;
    }

    public double distance(Cluster<?> o1, Cluster<?> o2) {
        int i = DBIDUtil.intersectionSize((DBIDs)o1.getIDs(), (DBIDs)o2.getIDs());
        int union = o1.size() + o2.size() - i;
        return 1.0 - (double)i / (double)union;
    }

    public boolean isSymmetric() {
        return true;
    }

    public boolean isMetric() {
        return true;
    }

    public <T extends Cluster<?>> DistanceSimilarityQuery<T> instantiate(Relation<T> relation) {
        return new PrimitiveDistanceSimilarityQuery(relation, (PrimitiveDistance)this, (PrimitiveSimilarity)this);
    }

    public SimpleTypeInformation<? super Cluster<?>> getInputTypeRestriction() {
        return new SimpleTypeInformation(Cluster.class);
    }

    public static class Par
    implements Parameterizer {
        public ClusterJaccardSimilarity make() {
            return STATIC;
        }
    }
}

