/*
 * Decompiled with CFR 0.152.
 */
package elki.similarity.cluster;

import elki.data.Clustering;
import elki.data.type.SimpleTypeInformation;
import elki.database.query.DistanceSimilarityQuery;
import elki.database.query.distance.PrimitiveDistanceSimilarityQuery;
import elki.database.relation.Relation;
import elki.distance.PrimitiveDistance;
import elki.evaluation.clustering.ClusterContingencyTable;
import elki.similarity.NormalizedSimilarity;
import elki.similarity.PrimitiveSimilarity;
import elki.similarity.cluster.ClusteringDistanceSimilarity;
import elki.utilities.documentation.Reference;
import elki.utilities.optionhandling.Parameterizer;

@Reference(authors="L. Hubert, P. Arabie", title="Comparing partitions", booktitle="Journal of Classification 2(193)", url="https://doi.org/10.1007/BF01908075", bibkey="doi:10.1007/BF01908075")
public class ClusteringAdjustedRandIndexSimilarity
implements ClusteringDistanceSimilarity,
NormalizedSimilarity<Clustering<?>> {
    public static final ClusteringAdjustedRandIndexSimilarity STATIC = new ClusteringAdjustedRandIndexSimilarity();

    public double similarity(Clustering<?> o1, Clustering<?> o2) {
        return new ClusterContingencyTable(false, true, o1, o2).getPaircount().adjustedRandIndex();
    }

    public double distance(Clustering<?> o1, Clustering<?> o2) {
        return 1.0 - new ClusterContingencyTable(false, true, o1, o2).getPaircount().adjustedRandIndex();
    }

    public boolean isMetric() {
        return false;
    }

    @Override
    public <T extends Clustering<?>> DistanceSimilarityQuery<T> instantiate(Relation<T> relation) {
        return new PrimitiveDistanceSimilarityQuery(relation, (PrimitiveDistance)this, (PrimitiveSimilarity)this);
    }

    public SimpleTypeInformation<? super Clustering<?>> getInputTypeRestriction() {
        return new SimpleTypeInformation(Clustering.class);
    }

    public static class Par
    implements Parameterizer {
        public ClusteringAdjustedRandIndexSimilarity make() {
            return STATIC;
        }
    }
}

