/*
 * Decompiled with CFR 0.152.
 */
package elki.similarity.cluster;

import elki.data.Clustering;
import elki.data.type.SimpleTypeInformation;
import elki.database.query.DistanceSimilarityQuery;
import elki.database.query.distance.PrimitiveDistanceSimilarityQuery;
import elki.database.relation.Relation;
import elki.distance.PrimitiveDistance;
import elki.evaluation.clustering.ClusterContingencyTable;
import elki.similarity.NormalizedSimilarity;
import elki.similarity.PrimitiveSimilarity;
import elki.similarity.cluster.ClusteringDistanceSimilarity;
import elki.utilities.documentation.Reference;
import elki.utilities.optionhandling.Parameterizer;

@Reference(authors="A. Bagga, B. Baldwin", title="Entity-based cross-document coreferencing using the Vector Space Model", booktitle="Proc. 17th Int. Conf. on Computational Linguistics (COLING '98)", url="https://doi.org/10.3115/980451.980859", bibkey="doi:10.3115/980451.980859")
public class ClusteringBCubedF1Similarity
implements ClusteringDistanceSimilarity,
NormalizedSimilarity<Clustering<?>> {
    public static final ClusteringBCubedF1Similarity STATIC = new ClusteringBCubedF1Similarity();

    public double similarity(Clustering<?> o1, Clustering<?> o2) {
        return new ClusterContingencyTable(false, true, o1, o2).getBCubed().f1Measure();
    }

    public double distance(Clustering<?> o1, Clustering<?> o2) {
        return 1.0 - new ClusterContingencyTable(false, true, o1, o2).getBCubed().f1Measure();
    }

    public boolean isMetric() {
        return false;
    }

    @Override
    public <T extends Clustering<?>> DistanceSimilarityQuery<T> instantiate(Relation<T> relation) {
        return new PrimitiveDistanceSimilarityQuery(relation, (PrimitiveDistance)this, (PrimitiveSimilarity)this);
    }

    public SimpleTypeInformation<? super Clustering<?>> getInputTypeRestriction() {
        return new SimpleTypeInformation(Clustering.class);
    }

    public static class Par
    implements Parameterizer {
        public ClusteringBCubedF1Similarity make() {
            return STATIC;
        }
    }
}

