/*
 * Decompiled with CFR 0.152.
 */
package elki.similarity.cluster;

import elki.data.Clustering;
import elki.data.type.SimpleTypeInformation;
import elki.database.query.DistanceSimilarityQuery;
import elki.database.query.distance.PrimitiveDistanceSimilarityQuery;
import elki.database.relation.Relation;
import elki.distance.PrimitiveDistance;
import elki.evaluation.clustering.ClusterContingencyTable;
import elki.similarity.NormalizedSimilarity;
import elki.similarity.PrimitiveSimilarity;
import elki.similarity.cluster.ClusteringDistanceSimilarity;
import elki.utilities.documentation.Reference;
import elki.utilities.optionhandling.Parameterizer;

@Reference(authors="E. B. Fowlkes, C. L. Mallows", title="A method for comparing two hierarchical clusterings", booktitle="Journal of the American Statistical Association, Vol. 78 Issue 383", url="https://doi.org/10.2307/2288117", bibkey="doi:10.2307/2288117")
public class ClusteringFowlkesMallowsSimilarity
implements ClusteringDistanceSimilarity,
NormalizedSimilarity<Clustering<?>> {
    public static final ClusteringFowlkesMallowsSimilarity STATIC = new ClusteringFowlkesMallowsSimilarity();

    public double similarity(Clustering<?> o1, Clustering<?> o2) {
        return new ClusterContingencyTable(false, true, o1, o2).getPaircount().fowlkesMallows();
    }

    public double distance(Clustering<?> o1, Clustering<?> o2) {
        return 1.0 - new ClusterContingencyTable(false, true, o1, o2).getPaircount().fowlkesMallows();
    }

    public boolean isMetric() {
        return false;
    }

    @Override
    public <T extends Clustering<?>> DistanceSimilarityQuery<T> instantiate(Relation<T> relation) {
        return new PrimitiveDistanceSimilarityQuery(relation, (PrimitiveDistance)this, (PrimitiveSimilarity)this);
    }

    public SimpleTypeInformation<? super Clustering<?>> getInputTypeRestriction() {
        return new SimpleTypeInformation(Clustering.class);
    }

    public static class Par
    implements Parameterizer {
        public ClusteringFowlkesMallowsSimilarity make() {
            return STATIC;
        }
    }
}

