/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering.trivial;

import elki.clustering.ClusteringAlgorithm;
import elki.clustering.trivial.ReferenceClustering;
import elki.data.Cluster;
import elki.data.Clustering;
import elki.data.model.Model;
import elki.data.synthetic.bymodel.GeneratorInterface;
import elki.data.type.TypeInformation;
import elki.data.type.TypeUtil;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDs;
import elki.database.ids.ModifiableDBIDs;
import elki.database.relation.Relation;
import elki.result.Metadata;
import elki.utilities.Priority;
import elki.utilities.documentation.Description;
import elki.utilities.documentation.Title;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.PatternParameter;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

@Title(value="Clustering by model")
@Description(value="Cluster points by a (pre-assigned!) model. For comparing results with a reference clustering.")
@Priority(value=-105)
public class ByModelClustering
implements ClusteringAlgorithm<Clustering<Model>> {
    private Pattern noisepattern = null;

    public ByModelClustering(Pattern noisepattern) {
        this.noisepattern = noisepattern;
    }

    public ByModelClustering() {
        this(null);
    }

    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array((TypeInformation[])new TypeInformation[]{Model.TYPE});
    }

    public Clustering<Model> run(Relation<Model> relation) {
        HashMap<Model, ModifiableDBIDs> modelMap = new HashMap<Model, ModifiableDBIDs>();
        DBIDIter iditer = relation.iterDBIDs();
        while (iditer.valid()) {
            modelMap.computeIfAbsent((Model)relation.get((DBIDRef)iditer), x -> DBIDUtil.newHashSet()).add((DBIDRef)iditer);
            iditer.advance();
        }
        ReferenceClustering result = new ReferenceClustering();
        Metadata.of((Object)result).setLongName("By Model Clustering");
        for (Map.Entry entry : modelMap.entrySet()) {
            Model model = (Model)entry.getKey();
            ModifiableDBIDs ids = (ModifiableDBIDs)entry.getValue();
            String name = model instanceof GeneratorInterface ? ((GeneratorInterface)model).getName() : model.toString();
            Cluster c = new Cluster(name, (DBIDs)ids, model);
            if (this.noisepattern != null && this.noisepattern.matcher(name).find()) {
                c.setNoise(true);
            }
            result.addToplevelCluster(c);
        }
        return result;
    }

    public static class Par
    implements Parameterizer {
        public static final OptionID NOISE_ID = new OptionID("bymodel.noise", "Pattern to recognize noise models by their label.");
        protected Pattern noisepat;

        public void configure(Parameterization config) {
            ((PatternParameter)new PatternParameter(NOISE_ID).setOptional(true)).grab(config, x -> {
                this.noisepat = x;
            });
        }

        public ByModelClustering make() {
            return new ByModelClustering(this.noisepat);
        }
    }
}

