/*
 * Decompiled with CFR 0.152.
 */
package elki.data.synthetic.bymodel;

import elki.data.model.ClusterModel;
import elki.data.model.Model;
import elki.data.synthetic.bymodel.GeneratorInterface;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class GeneratorStatic
implements GeneratorInterface {
    public String name;
    public List<double[]> points;

    public GeneratorStatic(String name, List<double[]> points) {
        this.name = name;
        this.points = points;
    }

    @Override
    public List<double[]> generate(int count) {
        return Collections.unmodifiableList(this.points);
    }

    @Override
    public double getDensity(double[] p) {
        for (double[] my : this.points) {
            if (!Arrays.equals(my, p)) continue;
            return Double.POSITIVE_INFINITY;
        }
        return 0.0;
    }

    @Override
    public int getDim() {
        return this.points.get(0).length;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getSize() {
        return this.points.size();
    }

    @Override
    public Model makeModel() {
        return ClusterModel.CLUSTER;
    }

    @Override
    public double[] computeMean() {
        return this.points.size() == 1 ? this.points.get(1) : null;
    }
}

