/*
 * Decompiled with CFR 0.152.
 */
package elki.outlier.trivial;

import elki.data.NumberVector;
import elki.data.model.Model;
import elki.data.synthetic.bymodel.GeneratorSingleCluster;
import elki.data.type.NoSupportedDataTypeException;
import elki.data.type.SimpleTypeInformation;
import elki.data.type.TypeInformation;
import elki.data.type.TypeUtil;
import elki.database.Database;
import elki.database.datastore.DataStoreUtil;
import elki.database.datastore.DoubleDataStore;
import elki.database.datastore.WritableDoubleDataStore;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDs;
import elki.database.relation.DoubleRelation;
import elki.database.relation.MaterializedDoubleRelation;
import elki.database.relation.Relation;
import elki.logging.Logging;
import elki.math.statistics.distribution.ChiSquaredDistribution;
import elki.math.statistics.distribution.Distribution;
import elki.math.statistics.distribution.NormalDistribution;
import elki.outlier.OutlierAlgorithm;
import elki.result.outlier.OutlierResult;
import elki.result.outlier.OutlierScoreMeta;
import elki.result.outlier.ProbabilisticOutlierScore;
import elki.utilities.exceptions.AbortException;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.constraints.CommonConstraints;
import elki.utilities.optionhandling.constraints.ParameterConstraint;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.DoubleParameter;
import java.util.HashSet;

public class TrivialGeneratedOutlier
implements OutlierAlgorithm {
    private static final Logging LOG = Logging.getLogger(TrivialGeneratedOutlier.class);
    double expect = 0.01;

    public TrivialGeneratedOutlier(double expect) {
        this.expect = expect;
    }

    public TrivialGeneratedOutlier() {
        this(0.01);
    }

    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array((TypeInformation[])new TypeInformation[]{TypeUtil.NUMBER_VECTOR_FIELD, new SimpleTypeInformation(Model.class), TypeUtil.GUESSED_LABEL});
    }

    public OutlierResult autorun(Database database) {
        Relation vecs = database.getRelation((TypeInformation)TypeUtil.NUMBER_VECTOR_FIELD, new Object[0]);
        Relation models = database.getRelation((TypeInformation)new SimpleTypeInformation(Model.class), new Object[0]);
        try {
            return this.run((Relation<Model>)models, (Relation<NumberVector>)vecs, database.getRelation((TypeInformation)TypeUtil.CLASSLABEL, new Object[0]));
        }
        catch (NoSupportedDataTypeException e) {
            return this.run((Relation<Model>)models, (Relation<NumberVector>)vecs, database.getRelation(TypeUtil.GUESSED_LABEL, new Object[0]));
        }
    }

    public OutlierResult run(Relation<Model> models, Relation<NumberVector> vecs, Relation<?> labels) {
        WritableDoubleDataStore scores = DataStoreUtil.makeDoubleStorage((DBIDs)models.getDBIDs(), (int)2);
        HashSet<GeneratorSingleCluster> generators = new HashSet<GeneratorSingleCluster>();
        Object iditer = models.iterDBIDs();
        while (iditer.valid()) {
            Model model = (Model)models.get((DBIDRef)iditer);
            if (model instanceof GeneratorSingleCluster) {
                generators.add((GeneratorSingleCluster)model);
            }
            iditer.advance();
        }
        if (generators.isEmpty()) {
            LOG.warning((CharSequence)"No generator models found for dataset - all points will be considered outliers.");
        }
        for (GeneratorSingleCluster gen : generators) {
            for (int i = 0; i < gen.getDim(); ++i) {
                Distribution dist = gen.getDistribution(i);
                if (dist instanceof NormalDistribution) continue;
                throw new AbortException("TrivialGeneratedOutlier currently only supports normal distributions, got: " + dist);
            }
        }
        iditer = models.iterDBIDs();
        while (iditer.valid()) {
            double score = 1.0;
            double[] v = ((NumberVector)vecs.get((DBIDRef)iditer)).toArray();
            for (GeneratorSingleCluster gen : generators) {
                double[] tv = v;
                if (gen.getTransformation() != null) {
                    tv = gen.getTransformation().applyInverse(v);
                }
                int dim = tv.length;
                double lensq = 0.0;
                int norm = 0;
                for (int i = 0; i < dim; ++i) {
                    Distribution dist = gen.getDistribution(i);
                    if (dist instanceof NormalDistribution) {
                        NormalDistribution d = (NormalDistribution)dist;
                        double delta = (tv[i] - d.getMean()) / d.getStddev();
                        lensq += delta * delta;
                        ++norm;
                        continue;
                    }
                    throw new AbortException("TrivialGeneratedOutlier currently only supports normal distributions, got: " + dist);
                }
                if ((double)norm > 0.0) {
                    score = Math.min(score, ChiSquaredDistribution.cdf((double)lensq, (double)norm));
                    continue;
                }
                score = 0.0;
            }
            if (this.expect < 1.0) {
                score = this.expect * score / (1.0 - score + this.expect);
            }
            scores.putDouble((DBIDRef)iditer, score);
            iditer.advance();
        }
        MaterializedDoubleRelation scoreres = new MaterializedDoubleRelation("Model outlier scores", models.getDBIDs(), (DoubleDataStore)scores);
        ProbabilisticOutlierScore meta = new ProbabilisticOutlierScore(0.0, 1.0);
        return new OutlierResult((OutlierScoreMeta)meta, (DoubleRelation)scoreres);
    }

    public static class Par
    implements Parameterizer {
        public static final OptionID EXPECT_ID = new OptionID("modeloutlier.expect", "Expected amount of outliers, for making the scores more intuitive. When the value is 1, the CDF will be given instead.");
        double expect;

        public void configure(Parameterization config) {
            ((DoubleParameter)((DoubleParameter)new DoubleParameter(EXPECT_ID, 0.01).addConstraint((ParameterConstraint)CommonConstraints.GREATER_THAN_ZERO_DOUBLE)).addConstraint((ParameterConstraint)CommonConstraints.LESS_EQUAL_ONE_DOUBLE)).grab(config, x -> {
                this.expect = x;
            });
        }

        public TrivialGeneratedOutlier make() {
            return new TrivialGeneratedOutlier(this.expect);
        }
    }
}

