/*
 * Decompiled with CFR 0.152.
 */
package elki.database;

import elki.data.type.NoSupportedDataTypeException;
import elki.data.type.SimpleTypeInformation;
import elki.data.type.TypeInformation;
import elki.database.Database;
import elki.database.DatabaseEventManager;
import elki.database.datastore.DataStoreListener;
import elki.database.ids.DBIDRef;
import elki.database.relation.Relation;
import elki.datasource.bundle.SingleObjectBundle;
import elki.index.IndexFactory;
import elki.logging.Logging;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public abstract class AbstractDatabase
implements Database {
    protected final DatabaseEventManager eventManager = new DatabaseEventManager();
    protected final List<Relation<?>> relations = new ArrayList();
    protected final Collection<IndexFactory<?>> indexFactories = new ArrayList();

    public SingleObjectBundle getBundle(DBIDRef id) {
        assert (id != null);
        try {
            SingleObjectBundle ret = new SingleObjectBundle();
            for (Relation<?> relation : this.relations) {
                ret.append(relation.getDataTypeInformation(), relation.get(id));
            }
            return ret;
        }
        catch (RuntimeException e) {
            if (id == null) {
                throw new UnsupportedOperationException("AbstractDatabase.getPackage(null) called!", e);
            }
            throw e;
        }
    }

    public Collection<Relation<?>> getRelations() {
        return Collections.unmodifiableCollection(this.relations);
    }

    public <O> Relation<O> getRelation(TypeInformation restriction, Object ... hints) throws NoSupportedDataTypeException {
        for (Relation<?> relation : this.relations) {
            if (!restriction.isAssignableFromType((TypeInformation)relation.getDataTypeInformation())) continue;
            return relation;
        }
        ArrayList<SimpleTypeInformation> types = new ArrayList<SimpleTypeInformation>(this.relations.size());
        for (Relation<?> relation : this.relations) {
            types.add(relation.getDataTypeInformation());
        }
        throw new NoSupportedDataTypeException(restriction, types);
    }

    public void addDataStoreListener(DataStoreListener l) {
        this.eventManager.addListener(l);
    }

    public void removeDataStoreListener(DataStoreListener l) {
        this.eventManager.removeListener(l);
    }

    public void accumulateDataStoreEvents() {
        this.eventManager.accumulateDataStoreEvents();
    }

    public void flushDataStoreEvents() {
        this.eventManager.flushDataStoreEvents();
    }

    public String getLongName() {
        return "Database";
    }

    public String getShortName() {
        return "database";
    }

    protected abstract Logging getLogger();

    public static abstract class Par
    implements Parameterizer {
        public static final OptionID DATABASE_CONNECTION_ID = new OptionID("dbc", "Database connection class.");
        public static final OptionID INDEX_ID = new OptionID("db.index", "Database indexes to add.");

        public abstract Database make();
    }
}

