/*
 * Decompiled with CFR 0.152.
 */
package elki.database;

import elki.data.type.SimpleTypeInformation;
import elki.data.type.TypeInformation;
import elki.database.AbstractDatabase;
import elki.database.UpdatableDatabase;
import elki.database.ids.ArrayModifiableDBIDs;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDVar;
import elki.database.ids.DBIDs;
import elki.database.ids.HashSetModifiableDBIDs;
import elki.database.relation.DBIDView;
import elki.database.relation.MaterializedRelation;
import elki.database.relation.ModifiableRelation;
import elki.database.relation.Relation;
import elki.datasource.DatabaseConnection;
import elki.datasource.FileBasedDatabaseConnection;
import elki.datasource.bundle.MultipleObjectsBundle;
import elki.datasource.bundle.ObjectBundle;
import elki.datasource.bundle.SingleObjectBundle;
import elki.index.Index;
import elki.index.IndexFactory;
import elki.logging.Logging;
import elki.result.Metadata;
import elki.utilities.datastructures.BitsUtil;
import elki.utilities.documentation.Description;
import elki.utilities.exceptions.AbortException;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.ObjectListParameter;
import elki.utilities.optionhandling.parameters.ObjectParameter;
import java.util.ArrayList;
import java.util.Collection;

@Description(value="Database using an in-memory hashtable and at least providing linear scans.")
public class HashmapDatabase
extends AbstractDatabase
implements UpdatableDatabase {
    private static final Logging LOG = Logging.getLogger(HashmapDatabase.class);
    private HashSetModifiableDBIDs ids;
    private final DBIDView idrep;
    protected DatabaseConnection databaseConnection;

    public HashmapDatabase(DatabaseConnection databaseConnection, Collection<? extends IndexFactory<?>> indexFactories) {
        this.databaseConnection = databaseConnection;
        this.ids = DBIDUtil.newHashSet();
        this.idrep = new DBIDView((DBIDs)this.ids);
        this.relations.add(this.idrep);
        Metadata.hierarchyOf((Object)this).addChild((Object)this.idrep);
        if (indexFactories != null) {
            this.indexFactories.addAll(indexFactories);
        }
    }

    public HashmapDatabase() {
        this(null, null);
    }

    public void initialize() {
        if (this.databaseConnection != null) {
            this.insert((ObjectBundle)this.databaseConnection.loadData());
            this.databaseConnection = null;
        }
    }

    public DBIDs insert(ObjectBundle objpackages) {
        if (objpackages.dataLength() == 0) {
            return DBIDUtil.EMPTYDBIDS;
        }
        ArrayModifiableDBIDs newids = DBIDUtil.newArray((int)objpackages.dataLength());
        Relation<?>[] targets = this.alignColumns(objpackages);
        DBIDVar var = DBIDUtil.newVar();
        for (int j = 0; j < objpackages.dataLength(); ++j) {
            if (!objpackages.assignDBID(j, var)) {
                var.set((DBIDRef)DBIDUtil.generateSingleDBID());
            }
            if (this.ids.contains((DBIDRef)var)) {
                throw new AbortException("Duplicate DBID conflict.");
            }
            this.ids.add((DBIDRef)var);
            for (int i = 0; i < targets.length; ++i) {
                if (!(targets[i] instanceof ModifiableRelation)) {
                    throw new AbortException("Non-modifiable relations have been added to the database.");
                }
                ModifiableRelation relation = (ModifiableRelation)targets[i];
                relation.insert((DBIDRef)var, objpackages.data(j, i));
            }
            newids.add((DBIDRef)var);
        }
        this.eventManager.fireObjectsInserted((DBIDs)newids);
        return newids;
    }

    protected Relation<?>[] alignColumns(ObjectBundle pack) {
        Relation[] targets = new Relation[pack.metaLength()];
        long[] used = BitsUtil.zero((int)this.relations.size());
        for (int i = 0; i < targets.length; ++i) {
            SimpleTypeInformation meta = pack.meta(i);
            int j = BitsUtil.nextClearBit((long[])used, (int)0);
            while (j >= 0 && j < this.relations.size()) {
                Relation relation = (Relation)this.relations.get(j);
                if (relation.getDataTypeInformation().isAssignableFromType((TypeInformation)meta)) {
                    targets[i] = relation;
                    BitsUtil.setI((long[])used, (int)j);
                    break;
                }
                j = BitsUtil.nextClearBit((long[])used, (int)(j + 1));
            }
            if (targets[i] != null) continue;
            targets[i] = this.addNewRelation(meta);
            BitsUtil.setI((long[])used, (int)(this.relations.size() - 1));
        }
        return targets;
    }

    private Relation<?> addNewRelation(SimpleTypeInformation<?> meta) {
        MaterializedRelation relation = new MaterializedRelation(null, meta, (DBIDs)this.ids);
        this.relations.add(relation);
        Metadata.hierarchyOf((Object)this).addChild(relation);
        for (IndexFactory factory : this.indexFactories) {
            if (!factory.getInputTypeRestriction().isAssignableFromType(meta)) continue;
            IndexFactory ofact = factory;
            MaterializedRelation orep = relation;
            Index index = ofact.instantiate(orep);
            index.initialize();
            Metadata.hierarchyOf(relation).addChild((Object)index);
        }
        return relation;
    }

    public MultipleObjectsBundle delete(DBIDs ids) {
        MultipleObjectsBundle bundle = new MultipleObjectsBundle();
        for (Relation relation : this.relations) {
            ArrayList<Object> data = new ArrayList<Object>(ids.size());
            DBIDIter iter = ids.iter();
            while (iter.valid()) {
                data.add(relation.get((DBIDRef)iter));
                iter.advance();
            }
            bundle.appendColumn(relation.getDataTypeInformation(), data);
        }
        DBIDIter iter = ids.iter();
        while (iter.valid()) {
            this.doDelete((DBIDRef)iter);
            iter.advance();
        }
        this.eventManager.fireObjectsRemoved(ids);
        return bundle;
    }

    public SingleObjectBundle delete(DBIDRef id) {
        SingleObjectBundle bundle = new SingleObjectBundle();
        for (Relation relation : this.relations) {
            bundle.append(relation.getDataTypeInformation(), relation.get(id));
        }
        this.doDelete(id);
        this.eventManager.fireObjectRemoved(id);
        return bundle;
    }

    private void doDelete(DBIDRef id) {
        this.ids.remove(id);
        for (Relation relation : this.relations) {
            if (relation == this.idrep) continue;
            if (!(relation instanceof ModifiableRelation)) {
                throw new AbortException("Non-modifiable relations have been added to the database.");
            }
            ((ModifiableRelation)relation).delete(id);
        }
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Par
    extends AbstractDatabase.Par {
        protected DatabaseConnection databaseConnection = null;
        private Collection<? extends IndexFactory<?>> indexFactories;

        public void configure(Parameterization config) {
            super.configure(config);
            new ObjectParameter(DATABASE_CONNECTION_ID, DatabaseConnection.class, FileBasedDatabaseConnection.class).grab(config, x -> {
                this.databaseConnection = x;
            });
            new ObjectListParameter(INDEX_ID, IndexFactory.class).setOptional(true).grab(config, x -> {
                this.indexFactories = x;
            });
        }

        @Override
        public HashmapDatabase make() {
            return new HashmapDatabase(this.databaseConnection, this.indexFactories);
        }
    }
}

