/*
 * Decompiled with CFR 0.152.
 */
package elki.database;

import elki.database.AbstractDatabase;
import elki.database.Database;
import elki.database.ids.DBIDs;
import elki.database.relation.DBIDView;
import elki.database.relation.ProxyView;
import elki.database.relation.Relation;
import elki.logging.Logging;
import elki.result.Metadata;
import java.util.Arrays;

public class ProxyDatabase
extends AbstractDatabase {
    private static final Logging LOG = Logging.getLogger(ProxyDatabase.class);
    protected DBIDView idrep;

    public ProxyDatabase(DBIDs ids) {
        this.idrep = new DBIDView(ids);
        this.relations.add(this.idrep);
        Metadata.hierarchyOf((Object)this).addChild((Object)this.idrep);
    }

    public ProxyDatabase(DBIDs ids, Iterable<Relation<?>> relations) {
        this.idrep = new DBIDView(ids);
        this.relations.add(this.idrep);
        Metadata.hierarchyOf((Object)this).addChild((Object)this.idrep);
        for (Relation<?> orel : relations) {
            ProxyView relation = new ProxyView(ids, orel);
            this.relations.add(relation);
            Metadata.hierarchyOf((Object)this).addChild(relation);
        }
    }

    public ProxyDatabase(DBIDs ids, Relation<?> ... relations) {
        this(ids, Arrays.asList(relations));
    }

    public ProxyDatabase(DBIDs ids, Database database) {
        this(ids, database.getRelations());
    }

    public void initialize() {
    }

    public void addRelation(Relation<?> relation) {
        this.relations.add(relation);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public void setDBIDs(DBIDs ids) {
        this.idrep.setDBIDs(ids);
        for (Relation orel : this.relations) {
            if (!(orel instanceof ProxyView)) continue;
            ((ProxyView)orel).setDBIDs(this.idrep.getDBIDs());
        }
    }
}

