/*
 * Decompiled with CFR 0.152.
 */
package elki.database;

import elki.data.type.SimpleTypeInformation;
import elki.data.type.TypeInformation;
import elki.database.AbstractDatabase;
import elki.database.datastore.DataStoreUtil;
import elki.database.datastore.WritableDataStore;
import elki.database.ids.ArrayDBIDs;
import elki.database.ids.ArrayStaticDBIDs;
import elki.database.ids.DBIDArrayIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDs;
import elki.database.relation.DBIDView;
import elki.database.relation.MaterializedRelation;
import elki.datasource.DatabaseConnection;
import elki.datasource.FileBasedDatabaseConnection;
import elki.datasource.bundle.MultipleObjectsBundle;
import elki.index.Index;
import elki.index.IndexFactory;
import elki.logging.Logging;
import elki.logging.statistics.Duration;
import elki.logging.statistics.Statistic;
import elki.result.Metadata;
import elki.utilities.documentation.Description;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.ObjectListParameter;
import elki.utilities.optionhandling.parameters.ObjectParameter;
import java.util.Collection;

@Description(value="Database using an in-memory hashtable and at least providing linear scans.")
public class StaticArrayDatabase
extends AbstractDatabase {
    private static final Logging LOG = Logging.getLogger(StaticArrayDatabase.class);
    private ArrayStaticDBIDs ids;
    private DBIDView idrep;
    protected DatabaseConnection databaseConnection;

    public StaticArrayDatabase(DatabaseConnection databaseConnection, Collection<? extends IndexFactory<?>> indexFactories) {
        this.databaseConnection = databaseConnection;
        this.ids = null;
        this.idrep = null;
        if (indexFactories != null) {
            this.indexFactories.addAll(indexFactories);
        }
    }

    public StaticArrayDatabase(DatabaseConnection databaseConnection) {
        this(databaseConnection, null);
    }

    public void initialize() {
        if (this.databaseConnection == null) {
            return;
        }
        if (LOG.isDebugging()) {
            LOG.debugFine((CharSequence)"Loading data from database connection.");
        }
        MultipleObjectsBundle bundle = this.databaseConnection.loadData();
        this.databaseConnection = null;
        ArrayDBIDs bids = bundle.getDBIDs();
        this.ids = bids instanceof ArrayStaticDBIDs ? (ArrayStaticDBIDs)bids : (bids == null ? DBIDUtil.generateStaticDBIDRange((int)bundle.dataLength()) : (ArrayStaticDBIDs)DBIDUtil.makeUnmodifiable((DBIDs)DBIDUtil.ensureArray((DBIDs)bids)));
        this.idrep = new DBIDView((DBIDs)this.ids);
        this.relations.add(this.idrep);
        Metadata.hierarchyOf((Object)this).addChild((Object)this.idrep);
        DBIDArrayIter it = this.ids.iter();
        int numrel = bundle.metaLength();
        for (int i = 0; i < numrel; ++i) {
            SimpleTypeInformation meta;
            SimpleTypeInformation ometa = meta = bundle.meta(i);
            WritableDataStore store = DataStoreUtil.makeStorage((DBIDs)this.ids, (int)30, (Class)ometa.getRestrictionClass());
            it.seek(0);
            while (it.valid()) {
                store.put((DBIDRef)it, bundle.data(it.getOffset(), i));
                it.advance();
            }
            MaterializedRelation relation = new MaterializedRelation(null, ometa, (DBIDs)this.ids, store);
            this.relations.add(relation);
            Metadata.hierarchyOf((Object)this).addChild(relation);
            for (IndexFactory factory : this.indexFactories) {
                if (!factory.getInputTypeRestriction().isAssignableFromType((TypeInformation)ometa)) continue;
                IndexFactory ofact = factory;
                MaterializedRelation orep = relation;
                Index index = ofact.instantiate(orep);
                Duration duration = LOG.isStatistics() ? LOG.newDuration(index.getClass().getName() + ".construction").begin() : null;
                index.initialize();
                if (duration != null) {
                    LOG.statistics((Statistic)duration.end());
                }
                Metadata.hierarchyOf(relation).addChild((Object)index);
            }
        }
        this.eventManager.fireObjectsInserted((DBIDs)this.ids);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Par
    extends AbstractDatabase.Par {
        protected DatabaseConnection databaseConnection = null;
        private Collection<? extends IndexFactory<?>> indexFactories;

        public void configure(Parameterization config) {
            super.configure(config);
            new ObjectParameter(DATABASE_CONNECTION_ID, DatabaseConnection.class, FileBasedDatabaseConnection.class).grab(config, x -> {
                this.databaseConnection = x;
            });
            new ObjectListParameter(INDEX_ID, IndexFactory.class).setOptional(true).grab(config, x -> {
                this.indexFactories = x;
            });
        }

        @Override
        public StaticArrayDatabase make() {
            return new StaticArrayDatabase(this.databaseConnection, this.indexFactories);
        }
    }
}

