/*
 * Decompiled with CFR 0.152.
 */
package elki.database.query;

import elki.data.type.FieldTypeInformation;
import elki.data.type.SimpleTypeInformation;
import elki.data.type.TypeInformation;
import elki.data.type.TypeUtil;
import elki.database.ids.DBIDRange;
import elki.database.ids.DBIDRef;
import elki.database.query.PrioritySearcher;
import elki.database.query.QueryOptimizer;
import elki.database.query.distance.DistanceQuery;
import elki.database.query.knn.KNNSearcher;
import elki.database.query.range.RangeSearcher;
import elki.database.relation.Relation;
import elki.distance.Distance;
import elki.distance.minkowski.LPNormDistance;
import elki.distance.minkowski.SquaredEuclideanDistance;
import elki.index.DistanceIndex;
import elki.index.DistancePriorityIndex;
import elki.index.Index;
import elki.index.KNNIndex;
import elki.logging.Logging;
import elki.result.Metadata;
import elki.utilities.Alias;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

@Alias(value={"auto"})
public class EmpiricalQueryOptimizer
implements QueryOptimizer {
    private static final Logging LOG = Logging.getLogger(EmpiricalQueryOptimizer.class);
    private static final long MEGA = 0x100000L;
    private final Constructor<? extends Index> matrixIndex;
    private final Constructor<? extends KNNIndex<?>> knnIndex;
    private final Constructor<? extends Index> coverIndex;
    private final Constructor<? extends Index> vpIndex;
    private final Constructor<? extends Index> kdIndex;

    public EmpiricalQueryOptimizer() {
        Constructor<?> matrixIndex = null;
        try {
            Class<?> cls = this.getClass().getClassLoader().loadClass("elki.index.distancematrix.PrecomputedDistanceMatrix");
            matrixIndex = cls.getConstructor(Relation.class, DBIDRange.class, Distance.class);
        }
        catch (ClassNotFoundException e) {
            LOG.verbose((CharSequence)"PrecomputedDistanceMatrix is not available, and cannot be automatically used for optimization.");
        }
        catch (NoSuchMethodException | SecurityException e) {
            LOG.exception((Throwable)e);
        }
        this.matrixIndex = matrixIndex;
        Constructor<?> knnIndex = null;
        try {
            Class<?> cls = this.getClass().getClassLoader().loadClass("elki.index.preprocessed.knn.MaterializeKNNPreprocessor");
            knnIndex = cls.getConstructor(Relation.class, DistanceQuery.class, Integer.TYPE, Boolean.TYPE);
        }
        catch (ClassNotFoundException e) {
            LOG.verbose((CharSequence)"MaterializeKNNPreprocessor is not available, and cannot be automatically used for optimization.");
        }
        catch (NoSuchMethodException | SecurityException e) {
            LOG.exception((Throwable)e);
        }
        this.knnIndex = knnIndex;
        Constructor<?> coverIndex = null;
        try {
            Class<?> cls = this.getClass().getClassLoader().loadClass("elki.index.tree.metrical.covertree.CoverTree");
            coverIndex = cls.getConstructor(Relation.class, Distance.class, Integer.TYPE);
        }
        catch (ClassNotFoundException e) {
            LOG.verbose((CharSequence)"CoverTree is not available, and cannot be automatically used for optimization.");
        }
        catch (NoSuchMethodException | SecurityException e) {
            LOG.exception((Throwable)e);
        }
        this.coverIndex = coverIndex;
        Constructor<?> vpIndex = null;
        try {
            Class<?> cls = this.getClass().getClassLoader().loadClass("elki.index.tree.metrical.vptree.VPTree");
            vpIndex = cls.getConstructor(Relation.class, Distance.class, Integer.TYPE);
        }
        catch (ClassNotFoundException e) {
            LOG.verbose((CharSequence)"VPTree is not available, and cannot be automatically used for optimization.");
        }
        catch (NoSuchMethodException | SecurityException e) {
            LOG.exception((Throwable)e);
        }
        this.vpIndex = vpIndex;
        Constructor<?> kdIndex = null;
        try {
            Class<?> cls = this.getClass().getClassLoader().loadClass("elki.index.tree.spatial.kd.MemoryKDTree");
            kdIndex = cls.getConstructor(Relation.class, Integer.TYPE);
        }
        catch (ClassNotFoundException e) {
            LOG.verbose((CharSequence)"MemoryKDTree is not available, and cannot be automatically used for optimization.");
        }
        catch (NoSuchMethodException | SecurityException e) {
            LOG.exception((Throwable)e);
        }
        this.kdIndex = kdIndex;
    }

    @Override
    public <O> DistanceQuery<O> getDistanceQuery(Relation<? extends O> relation, Distance<? super O> distance, int flags) {
        DistanceIndex idx;
        if ((flags & 0x20) != 0 && (idx = (DistanceIndex)this.makeMatrixIndex(relation, distance)) != null) {
            if ((flags & 0x10) == 0) {
                Metadata.hierarchyOf(relation).addWeakChild((Object)idx);
            }
            return idx.getDistanceQuery(distance);
        }
        return null;
    }

    @Override
    public <O> KNNSearcher<O> kNNByObject(Relation<? extends O> relation, DistanceQuery<O> distanceQuery, int maxk, int flags) {
        KNNIndex<? extends O> idx = null;
        if ((flags & 0x20) != 0) {
            idx = this.makeKnnPreprocessor(relation, distanceQuery, maxk, flags & 0xFFFFFFDF);
        }
        if (idx == null) {
            idx = this.makeKDTree(relation, distanceQuery.getDistance(), 3);
        }
        if (idx == null) {
            idx = this.makeVPTree(relation, distanceQuery.getDistance(), 5);
        }
        if (idx == null) {
            idx = this.makeCoverTree(relation, distanceQuery.getDistance(), 20);
        }
        if (idx != null) {
            if ((flags & 0x10) == 0) {
                Metadata.hierarchyOf(relation).addWeakChild(idx);
            }
            return idx.kNNByObject(distanceQuery, maxk, flags);
        }
        return null;
    }

    @Override
    public <O> KNNSearcher<DBIDRef> kNNByDBID(Relation<? extends O> relation, DistanceQuery<O> distanceQuery, int maxk, int flags) {
        KNNIndex<? extends O> idx = null;
        if ((flags & 0x20) != 0) {
            idx = this.makeKnnPreprocessor(relation, distanceQuery, maxk, flags & 0xFFFFFFDF);
        }
        if (idx == null) {
            idx = this.makeKDTree(relation, distanceQuery.getDistance(), 3);
        }
        if (idx == null) {
            idx = this.makeVPTree(relation, distanceQuery.getDistance(), 5);
        }
        if (idx == null) {
            idx = this.makeCoverTree(relation, distanceQuery.getDistance(), 20);
        }
        if (idx == null && (flags & 0x20) != 0 && relation.getDBIDs() instanceof DBIDRange) {
            idx = this.makeMatrixIndex(relation, distanceQuery.getDistance());
        }
        if (idx != null) {
            if ((flags & 0x10) == 0) {
                Metadata.hierarchyOf(relation).addWeakChild(idx);
            }
            return idx.kNNByDBID(distanceQuery, maxk, flags);
        }
        return null;
    }

    @Override
    public <O> RangeSearcher<O> rangeByObject(Relation<? extends O> relation, DistanceQuery<O> distanceQuery, double maxrange, int flags) {
        DistancePriorityIndex<? extends O> idx = null;
        if (idx == null) {
            idx = this.makeKDTree(relation, distanceQuery.getDistance(), 3);
        }
        if (idx == null) {
            idx = this.makeVPTree(relation, distanceQuery.getDistance(), 5);
        }
        if (idx == null) {
            idx = this.makeCoverTree(relation, distanceQuery.getDistance(), 20);
        }
        if (idx == null) {
            return null;
        }
        if ((flags & 0x10) == 0) {
            Metadata.hierarchyOf(relation).addWeakChild(idx);
        }
        return idx.rangeByObject(distanceQuery, maxrange, flags);
    }

    @Override
    public <O> RangeSearcher<DBIDRef> rangeByDBID(Relation<? extends O> relation, DistanceQuery<O> distanceQuery, double maxrange, int flags) {
        DistancePriorityIndex<? extends O> idx = null;
        if (idx == null) {
            idx = this.makeKDTree(relation, distanceQuery.getDistance(), 3);
        }
        if (idx == null) {
            idx = this.makeVPTree(relation, distanceQuery.getDistance(), 5);
        }
        if (idx == null) {
            idx = this.makeCoverTree(relation, distanceQuery.getDistance(), 20);
        }
        if (idx == null && (flags & 0x20) != 0 && relation.getDBIDs() instanceof DBIDRange) {
            idx = this.makeMatrixIndex(relation, distanceQuery.getDistance());
        }
        if (idx == null) {
            return null;
        }
        if ((flags & 0x10) == 0) {
            Metadata.hierarchyOf(relation).addWeakChild(idx);
        }
        return idx.rangeByDBID(distanceQuery, maxrange, flags);
    }

    @Override
    public <O> PrioritySearcher<O> priorityByObject(Relation<? extends O> relation, DistanceQuery<O> distanceQuery, double maxrange, int flags) {
        DistancePriorityIndex<? extends O> idx = null;
        if (idx == null) {
            idx = this.makeVPTree(relation, distanceQuery.getDistance(), 8);
        }
        if (idx == null) {
            idx = this.makeCoverTree(relation, distanceQuery.getDistance(), 20);
        }
        if (idx == null) {
            idx = this.makeKDTree(relation, distanceQuery.getDistance(), 10);
        }
        if (idx == null) {
            return null;
        }
        if ((flags & 0x10) == 0) {
            Metadata.hierarchyOf(relation).addWeakChild(idx);
        }
        return idx.priorityByObject(distanceQuery, maxrange, flags);
    }

    @Override
    public <O> PrioritySearcher<DBIDRef> priorityByDBID(Relation<? extends O> relation, DistanceQuery<O> distanceQuery, double maxrange, int flags) {
        DistancePriorityIndex<? extends O> idx = null;
        if (idx == null) {
            idx = this.makeVPTree(relation, distanceQuery.getDistance(), 8);
        }
        if (idx == null) {
            idx = this.makeCoverTree(relation, distanceQuery.getDistance(), 20);
        }
        if (idx == null) {
            idx = this.makeKDTree(relation, distanceQuery.getDistance(), 10);
        }
        if (idx == null && (flags & 0x20) != 0) {
            idx = this.makeMatrixIndex(relation, distanceQuery.getDistance());
        }
        if (idx == null) {
            return null;
        }
        if ((flags & 0x10) == 0) {
            Metadata.hierarchyOf(relation).addWeakChild(idx);
        }
        return idx.priorityByDBID(distanceQuery, maxrange, flags);
    }

    private <O> DistancePriorityIndex<O> makeMatrixIndex(Relation<? extends O> relation, Distance<? super O> distance) {
        if (this.matrixIndex == null || relation.size() > 65536) {
            return null;
        }
        long freeMemory = EmpiricalQueryOptimizer.getFreeMemory();
        long msize = (long)relation.size() * 4L * (long)relation.size();
        if ((double)msize > 0.8 * (double)freeMemory) {
            LOG.warning((CharSequence)("An automatic distance matrix would need about " + EmpiricalQueryOptimizer.formatMemory(msize) + " memory, only " + EmpiricalQueryOptimizer.formatMemory(freeMemory) + " are available."));
            return null;
        }
        if (!(relation.getDBIDs() instanceof DBIDRange)) {
            LOG.warning((CharSequence)"Optimizer: Precomputed distance matrixes can currently only be generated for a fixed DBID range - performance may be suboptimal.");
            return null;
        }
        try {
            DistancePriorityIndex idx = (DistancePriorityIndex)this.matrixIndex.newInstance(relation, (DBIDRange)relation.getDBIDs(), distance);
            LOG.verbose((CharSequence)"Optimizer: automatically adding a distance matrix.");
            idx.initialize();
            return idx;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            LOG.exception((CharSequence)"Automatic distance-matrix creation failed.", (Throwable)e);
            return null;
        }
    }

    private <O> DistancePriorityIndex<O> makeCoverTree(Relation<? extends O> relation, Distance<? super O> distance, int leafsize) {
        if (this.coverIndex == null || !distance.isMetric()) {
            return null;
        }
        try {
            DistancePriorityIndex idx = (DistancePriorityIndex)this.coverIndex.newInstance(relation, distance, leafsize);
            LOG.verbose((CharSequence)"Optimizer: automatically adding a cover tree index.");
            idx.initialize();
            return idx;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            LOG.exception((CharSequence)"Automatic cover tree creation failed.", (Throwable)e);
            return null;
        }
    }

    private <O> DistancePriorityIndex<O> makeVPTree(Relation<? extends O> relation, Distance<? super O> distance, int leafsize) {
        if (this.vpIndex == null || !distance.isMetric()) {
            return null;
        }
        try {
            DistancePriorityIndex idx = (DistancePriorityIndex)this.vpIndex.newInstance(relation, distance, leafsize);
            LOG.verbose((CharSequence)"Optimizer: automatically adding a VP tree index.");
            idx.initialize();
            return idx;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            LOG.exception((CharSequence)"Automatic VP tree creation failed.", (Throwable)e);
            return null;
        }
    }

    private <O> DistancePriorityIndex<O> makeKDTree(Relation<? extends O> relation, Distance<? super O> distance, int k) {
        SimpleTypeInformation type = relation.getDataTypeInformation();
        if (this.kdIndex == null || !TypeUtil.NUMBER_VECTOR_FIELD.isAssignableFromType((TypeInformation)type) || !(distance instanceof LPNormDistance) && !(distance instanceof SquaredEuclideanDistance) || ((FieldTypeInformation)type).getDimensionality() > 30) {
            return null;
        }
        try {
            DistancePriorityIndex idx = (DistancePriorityIndex)this.kdIndex.newInstance(relation, k > 0 ? k : 0);
            LOG.verbose((CharSequence)"Optimizer: automatically adding a k-d-tree index.");
            idx.initialize();
            return idx;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            LOG.exception((CharSequence)"Automatic k-d-tree creation failed.", (Throwable)e);
            return null;
        }
    }

    private <O> KNNIndex<O> makeKnnPreprocessor(Relation<? extends O> relation, DistanceQuery<O> distanceQuery, int maxk, int flags) {
        if (this.knnIndex == null) {
            return null;
        }
        long freeMemory = EmpiricalQueryOptimizer.getFreeMemory();
        long msize = (long)maxk * 12L * (long)relation.size();
        if ((double)msize > 0.8 * (double)freeMemory) {
            LOG.warning((CharSequence)("Precomputing the kNN would need about " + EmpiricalQueryOptimizer.formatMemory(msize) + " memory, only " + EmpiricalQueryOptimizer.formatMemory(freeMemory) + " are available."));
            return null;
        }
        try {
            KNNIndex<?> idx = this.knnIndex.newInstance(relation, distanceQuery, maxk, true);
            LOG.verbose((CharSequence)"Optimizer: Automatically adding a knn preprocessor.");
            idx.initialize();
            if ((flags & 0x10) == 0) {
                Metadata.hierarchyOf(relation).addWeakChild(idx);
            }
            return idx;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            LOG.exception((CharSequence)"Automatic knn preprocessor creation failed.", (Throwable)e);
            return null;
        }
    }

    private static long getFreeMemory() {
        Runtime r = Runtime.getRuntime();
        return r.freeMemory() + r.maxMemory() - r.totalMemory();
    }

    private static String formatMemory(long mem) {
        return mem < 2621440000L ? (double)((int)((double)mem * 10.0 / 1048576.0)) / 10.0 + "M" : (double)((int)((double)mem / 102.4 / 1048576.0)) / 10.0 + "G";
    }
}

