/*
 * Decompiled with CFR 0.152.
 */
package elki.database.query;

import elki.database.ids.DBIDRef;
import elki.database.query.DisableQueryOptimizer;
import elki.database.query.EmpiricalQueryOptimizer;
import elki.database.query.PrioritySearcher;
import elki.database.query.QueryOptimizer;
import elki.database.query.distance.DistanceQuery;
import elki.database.query.distance.LinearScanEuclideanPrioritySearcher;
import elki.database.query.distance.LinearScanPrioritySearcher;
import elki.database.query.distance.PrimitiveDistanceQuery;
import elki.database.query.knn.KNNSearcher;
import elki.database.query.knn.LinearScanEuclideanKNNByObject;
import elki.database.query.knn.LinearScanKNNByDBID;
import elki.database.query.knn.LinearScanKNNByObject;
import elki.database.query.knn.LinearScanPrimitiveKNNByObject;
import elki.database.query.knn.WrappedKNNDBIDByLookup;
import elki.database.query.range.LinearScanDistanceRangeByDBID;
import elki.database.query.range.LinearScanDistanceRangeByObject;
import elki.database.query.range.LinearScanEuclideanRangeByObject;
import elki.database.query.range.LinearScanPrimitiveDistanceRangeByObject;
import elki.database.query.range.LinearScanPrimitiveSimilarityRangeByObject;
import elki.database.query.range.LinearScanSimilarityRangeByDBID;
import elki.database.query.range.LinearScanSimilarityRangeByObject;
import elki.database.query.range.RangeSearcher;
import elki.database.query.range.WrappedRangeDBIDByLookup;
import elki.database.query.rknn.LinearScanRKNNByDBID;
import elki.database.query.rknn.LinearScanRKNNByObject;
import elki.database.query.rknn.RKNNSearcher;
import elki.database.query.similarity.PrimitiveSimilarityQuery;
import elki.database.query.similarity.SimilarityQuery;
import elki.database.relation.Relation;
import elki.distance.DBIDDistance;
import elki.distance.Distance;
import elki.distance.minkowski.EuclideanDistance;
import elki.index.DistanceIndex;
import elki.index.DistancePriorityIndex;
import elki.index.Index;
import elki.index.KNNIndex;
import elki.index.RKNNIndex;
import elki.index.RangeIndex;
import elki.index.SimilarityIndex;
import elki.index.SimilarityRangeIndex;
import elki.logging.Logging;
import elki.result.Metadata;
import elki.similarity.DBIDSimilarity;
import elki.similarity.Similarity;
import elki.utilities.ClassGenericsUtil;
import elki.utilities.ELKIServiceRegistry;
import elki.utilities.datastructures.iterator.It;
import elki.utilities.exceptions.AbortException;
import elki.utilities.exceptions.ClassInstantiationException;
import elki.utilities.optionhandling.parameterization.EmptyParameterization;
import elki.utilities.optionhandling.parameterization.Parameterization;
import java.util.Objects;

public class QueryBuilder<O> {
    private static final Logging LOG = Logging.getLogger(QueryBuilder.class);
    public static final int FLAG_LINEAR_ONLY = 1;
    public static final int FLAG_OPTIMIZED_ONLY = 2;
    public static final int FLAG_EXACT_ONLY = 4;
    public static final int FLAG_CHEAP_ONLY = 8;
    public static final int FLAG_NO_CACHE = 16;
    public static final int FLAG_PRECOMPUTE = 32;
    public static final int FLAGS_NO_OPTIMIZER = 9;
    public static final int FLAGS_NO_INHERIT = 32;
    private static final QueryOptimizer OPTIMIZER = QueryBuilder.initStaticOptimizer();
    private Relation<O> relation;
    private Distance<? super O> distance;
    private Similarity<? super O> similarity;
    private DistanceQuery<O> distQuery;
    private SimilarityQuery<O> simQuery;
    private int flags;

    public QueryBuilder(Relation<O> relation, Distance<? super O> distance) {
        this.relation = Objects.requireNonNull(relation);
        this.distance = distance;
    }

    public QueryBuilder(DistanceQuery<? super O> distQuery) {
        this.distQuery = distQuery;
        this.relation = distQuery.getRelation();
        this.distance = distQuery.getDistance();
    }

    public QueryBuilder(Relation<O> relation, Similarity<? super O> similarity) {
        this.relation = Objects.requireNonNull(relation);
        this.similarity = similarity;
    }

    public QueryBuilder(SimilarityQuery<? super O> simQuery) {
        this.simQuery = simQuery;
        this.relation = simQuery.getRelation();
        this.similarity = simQuery.getSimilarity();
    }

    public QueryBuilder<O> linearOnly() {
        assert ((this.flags & 2) == 0);
        this.flags |= 1;
        return this;
    }

    public QueryBuilder<O> optimizedOnly() {
        assert ((this.flags & 1) == 0);
        this.flags |= 2;
        return this;
    }

    public QueryBuilder<O> exactOnly() {
        this.flags |= 4;
        return this;
    }

    public QueryBuilder<O> cheapOnly() {
        this.flags |= 8;
        return this;
    }

    public QueryBuilder<O> noCache() {
        this.flags |= 0x10;
        return this;
    }

    public QueryBuilder<O> precomputed() {
        this.flags |= 0x20;
        return this;
    }

    public DistanceQuery<O> distanceQuery() {
        if (this.distQuery != null) {
            return this.distQuery;
        }
        if (this.distance == null) {
            throw new IllegalStateException("Distance query requested for 'null' distance!");
        }
        It it = Metadata.hierarchyOf(this.relation).iterChildrenReverse().filter(DistanceIndex.class);
        while (it.valid()) {
            this.distQuery = ((DistanceIndex)it.get()).getDistanceQuery(this.distance);
            this.logUsing((Index)it.get(), "distance", this.distQuery != null);
            if (this.distQuery != null) {
                return this.distQuery;
            }
            it.advance();
        }
        if ((this.flags & 9) == 0) {
            this.distQuery = OPTIMIZER.getDistanceQuery(this.relation, this.distance, this.flags);
            if (this.distQuery != null) {
                return this.distQuery;
            }
        }
        if ((this.flags & 2) != 0 && !(this.distance instanceof DBIDDistance)) {
            return null;
        }
        if ((this.flags & 0x20) != 0) {
            LOG.warning((CharSequence)"The algorithm requested a distance matrix, but we could not precompute one.\n This may or may not be very expensive / slow.", new Throwable());
        }
        this.distQuery = this.distance.instantiate(this.relation);
        return this.distQuery;
    }

    public SimilarityQuery<O> similarityQuery() {
        if (this.simQuery != null) {
            return this.simQuery;
        }
        if (this.similarity == null) {
            throw new IllegalStateException("Similarity query requested for 'null' similarity!");
        }
        It it = Metadata.hierarchyOf(this.relation).iterChildrenReverse().filter(SimilarityIndex.class);
        while (it.valid()) {
            this.simQuery = ((SimilarityIndex)it.get()).getSimilarityQuery(this.similarity);
            this.logUsing((Index)it.get(), "similarity", this.simQuery != null);
            if (this.simQuery != null) {
                return this.simQuery;
            }
            it.advance();
        }
        if ((this.flags & 9) == 0) {
            this.simQuery = OPTIMIZER.getSimilarityQuery(this.relation, this.similarity, this.flags);
            if (this.simQuery != null) {
                return this.simQuery;
            }
        }
        if ((this.flags & 2) != 0 && !(this.similarity instanceof DBIDSimilarity)) {
            return null;
        }
        return this.similarity.instantiate(this.relation);
    }

    public KNNSearcher<O> kNNByObject() {
        return this.kNNByObject(Integer.MAX_VALUE);
    }

    public KNNSearcher<O> kNNByObject(int maxk) {
        KNNSearcher<O> q;
        int precompute = this.flags & 0x20;
        this.flags ^= precompute;
        DistanceQuery<O> distanceQuery = this.distanceQuery();
        this.flags ^= precompute;
        It it = Metadata.hierarchyOf(this.relation).iterChildrenReverse().filter(KNNIndex.class);
        while (it.valid()) {
            KNNSearcher q2 = ((KNNIndex)it.get()).kNNByObject(distanceQuery, maxk, this.flags);
            this.logUsing((Index)it.get(), "kNN", q2 != null);
            if (q2 != null) {
                return q2;
            }
            it.advance();
        }
        if ((this.flags & 9) == 0 && (q = OPTIMIZER.kNNByObject(this.relation, distanceQuery, maxk, this.flags)) != null) {
            return q;
        }
        if ((this.flags & 2) != 0) {
            return null;
        }
        this.logNotAccelerated("knn");
        if (distanceQuery instanceof PrimitiveDistanceQuery) {
            PrimitiveDistanceQuery pdq = (PrimitiveDistanceQuery)distanceQuery;
            if (EuclideanDistance.STATIC.equals((Object)pdq.getDistance())) {
                PrimitiveDistanceQuery ndq = pdq;
                return new LinearScanEuclideanKNNByObject(ndq);
            }
            return new LinearScanPrimitiveKNNByObject(pdq);
        }
        return new LinearScanKNNByObject<O>(distanceQuery);
    }

    public KNNSearcher<DBIDRef> kNNByDBID() {
        return this.kNNByDBID(Integer.MAX_VALUE);
    }

    public KNNSearcher<DBIDRef> kNNByDBID(int maxk) {
        KNNSearcher<DBIDRef> q;
        int precompute = this.flags & 0x20;
        this.flags ^= precompute;
        DistanceQuery<O> distanceQuery = this.distanceQuery();
        this.flags ^= precompute;
        It it = Metadata.hierarchyOf(this.relation).iterChildrenReverse().filter(KNNIndex.class);
        while (it.valid()) {
            KNNSearcher q2 = ((KNNIndex)it.get()).kNNByDBID(distanceQuery, maxk, this.flags);
            this.logUsing((Index)it.get(), "kNN", q2 != null);
            if (q2 != null) {
                return q2;
            }
            it.advance();
        }
        if ((this.flags & 9) == 0 && (q = OPTIMIZER.kNNByDBID(this.relation, distanceQuery, maxk, this.flags)) != null) {
            return q;
        }
        if ((this.flags & 2) != 0) {
            return null;
        }
        this.logNotAccelerated("knn");
        if (distanceQuery instanceof PrimitiveDistanceQuery) {
            PrimitiveDistanceQuery pdq = (PrimitiveDistanceQuery)distanceQuery;
            if (EuclideanDistance.STATIC.equals((Object)pdq.getDistance())) {
                PrimitiveDistanceQuery ndq = pdq;
                return WrappedKNNDBIDByLookup.wrap((Relation)ndq.getRelation(), new LinearScanEuclideanKNNByObject(ndq));
            }
            return WrappedKNNDBIDByLookup.wrap((Relation)pdq.getRelation(), new LinearScanPrimitiveKNNByObject(pdq));
        }
        return new LinearScanKNNByDBID<O>(distanceQuery);
    }

    public RangeSearcher<O> rangeByObject() {
        return this.rangeByObject(Double.POSITIVE_INFINITY);
    }

    public RangeSearcher<O> rangeByObject(double maxrange) {
        RangeSearcher<O> q;
        int precompute = this.flags & 0x20;
        this.flags ^= precompute;
        DistanceQuery<O> distanceQuery = this.distanceQuery();
        this.flags ^= precompute;
        It it = Metadata.hierarchyOf(this.relation).iterChildrenReverse().filter(RangeIndex.class);
        while (it.valid()) {
            RangeSearcher q2 = ((RangeIndex)it.get()).rangeByObject(distanceQuery, maxrange, this.flags);
            this.logUsing((Index)it.get(), "range", q2 != null);
            if (q2 != null) {
                return q2;
            }
            it.advance();
        }
        if ((this.flags & 9) == 0 && (q = OPTIMIZER.rangeByObject(this.relation, distanceQuery, maxrange, this.flags)) != null) {
            return q;
        }
        if ((this.flags & 2) != 0) {
            return null;
        }
        this.logNotAccelerated("range");
        if (distanceQuery instanceof PrimitiveDistanceQuery) {
            PrimitiveDistanceQuery pdq = (PrimitiveDistanceQuery)distanceQuery;
            if (EuclideanDistance.STATIC.equals(this.distance)) {
                PrimitiveDistanceQuery ndq = pdq;
                return new LinearScanEuclideanRangeByObject(ndq);
            }
            return new LinearScanPrimitiveDistanceRangeByObject(pdq);
        }
        return new LinearScanDistanceRangeByObject<O>(distanceQuery);
    }

    public RangeSearcher<DBIDRef> rangeByDBID() {
        return this.rangeByDBID(Double.POSITIVE_INFINITY);
    }

    public RangeSearcher<DBIDRef> rangeByDBID(double maxrange) {
        RangeSearcher<DBIDRef> q;
        int precompute = this.flags & 0x20;
        this.flags ^= precompute;
        DistanceQuery<O> distanceQuery = this.distanceQuery();
        this.flags ^= precompute;
        It it = Metadata.hierarchyOf(this.relation).iterChildrenReverse().filter(RangeIndex.class);
        while (it.valid()) {
            RangeSearcher q2 = ((RangeIndex)it.get()).rangeByDBID(distanceQuery, maxrange, this.flags);
            this.logUsing((Index)it.get(), "range", q2 != null);
            if (q2 != null) {
                return q2;
            }
            it.advance();
        }
        if ((this.flags & 9) == 0 && (q = OPTIMIZER.rangeByDBID(this.relation, distanceQuery, maxrange, this.flags)) != null) {
            return q;
        }
        if ((this.flags & 2) != 0) {
            return null;
        }
        this.logNotAccelerated("range");
        if (distanceQuery instanceof PrimitiveDistanceQuery) {
            PrimitiveDistanceQuery pdq = (PrimitiveDistanceQuery)distanceQuery;
            if (EuclideanDistance.STATIC.equals(this.distance)) {
                PrimitiveDistanceQuery ndq = pdq;
                return WrappedRangeDBIDByLookup.wrap((Relation)ndq.getRelation(), new LinearScanEuclideanRangeByObject(ndq));
            }
            return WrappedRangeDBIDByLookup.wrap((Relation)pdq.getRelation(), new LinearScanPrimitiveDistanceRangeByObject(pdq));
        }
        return new LinearScanDistanceRangeByDBID<O>(distanceQuery);
    }

    public RangeSearcher<O> similarityRangeByObject() {
        return this.similarityRangeByObject(Double.NEGATIVE_INFINITY);
    }

    public RangeSearcher<O> similarityRangeByObject(double threshold) {
        RangeSearcher<O> q;
        int precompute = this.flags & 0x20;
        this.flags ^= precompute;
        SimilarityQuery<O> simQuery = this.similarityQuery();
        this.flags ^= precompute;
        It it = Metadata.hierarchyOf(this.relation).iterChildrenReverse().filter(SimilarityRangeIndex.class);
        while (it.valid()) {
            RangeSearcher q2 = ((SimilarityRangeIndex)it.get()).similarityRangeByObject(simQuery, threshold, this.flags);
            this.logUsing((Index)it.get(), "similarity", q2 != null);
            if (q2 != null) {
                return q2;
            }
            it.advance();
        }
        if ((this.flags & 9) == 0 && (q = OPTIMIZER.similarityRangeByObject(this.relation, simQuery, threshold, this.flags)) != null) {
            return q;
        }
        if ((this.flags & 2) != 0) {
            return null;
        }
        this.logNotAccelerated("simrange");
        return simQuery instanceof PrimitiveSimilarityQuery ? new LinearScanPrimitiveSimilarityRangeByObject((PrimitiveSimilarityQuery)simQuery) : new LinearScanSimilarityRangeByObject<O>(simQuery);
    }

    public RangeSearcher<DBIDRef> similarityRangeByDBID() {
        return this.similarityRangeByDBID(Double.NEGATIVE_INFINITY);
    }

    public RangeSearcher<DBIDRef> similarityRangeByDBID(double threshold) {
        RangeSearcher<DBIDRef> q;
        int precompute = this.flags & 0x20;
        this.flags ^= precompute;
        SimilarityQuery<O> simQuery = this.similarityQuery();
        this.flags ^= precompute;
        It it = Metadata.hierarchyOf(this.relation).iterChildrenReverse().filter(SimilarityRangeIndex.class);
        while (it.valid()) {
            RangeSearcher q2 = ((SimilarityRangeIndex)it.get()).similarityRangeByDBID(simQuery, threshold, this.flags);
            this.logUsing((Index)it.get(), "similarity", q2 != null);
            if (q2 != null) {
                return q2;
            }
            it.advance();
        }
        if ((this.flags & 9) == 0 && (q = OPTIMIZER.similarityRangeByDBID(this.relation, simQuery, threshold, this.flags)) != null) {
            return q;
        }
        if ((this.flags & 2) != 0) {
            return null;
        }
        this.logNotAccelerated("simrange");
        return simQuery instanceof PrimitiveSimilarityQuery ? WrappedRangeDBIDByLookup.wrap((Relation)simQuery.getRelation(), new LinearScanPrimitiveSimilarityRangeByObject((PrimitiveSimilarityQuery)simQuery)) : new LinearScanSimilarityRangeByDBID(simQuery);
    }

    public RKNNSearcher<O> rKNNByObject() {
        return this.rKNNByObject(Integer.MAX_VALUE);
    }

    public RKNNSearcher<O> rKNNByObject(int k) {
        RKNNSearcher<O> q;
        int precompute = this.flags & 0x20;
        this.flags ^= precompute;
        DistanceQuery<O> distanceQuery = this.distanceQuery();
        this.flags ^= precompute;
        It it = Metadata.hierarchyOf(this.relation).iterChildrenReverse().filter(RKNNIndex.class);
        while (it.valid()) {
            RKNNSearcher q2 = ((RKNNIndex)it.get()).rkNNByObject(distanceQuery, k, this.flags);
            this.logUsing((Index)it.get(), "RkNN", q2 != null);
            if (q2 != null) {
                return q2;
            }
            it.advance();
        }
        if ((this.flags & 9) == 0 && (q = OPTIMIZER.rkNNByObject(this.relation, distanceQuery, k, this.flags)) != null) {
            return q;
        }
        if ((this.flags & 2) != 0) {
            return null;
        }
        this.logNotAccelerated("rknn");
        return new LinearScanRKNNByObject<O>(distanceQuery, this.kNNByDBID());
    }

    public RKNNSearcher<DBIDRef> rKNNByDBID() {
        return this.rKNNByDBID(Integer.MAX_VALUE);
    }

    public RKNNSearcher<DBIDRef> rKNNByDBID(int k) {
        RKNNSearcher<DBIDRef> q;
        int precompute = this.flags & 0x20;
        this.flags ^= precompute;
        DistanceQuery<O> distanceQuery = this.distanceQuery();
        this.flags ^= precompute;
        It it = Metadata.hierarchyOf(this.relation).iterChildrenReverse().filter(RKNNIndex.class);
        while (it.valid()) {
            RKNNSearcher q2 = ((RKNNIndex)it.get()).rkNNByDBID(distanceQuery, k, this.flags);
            this.logUsing((Index)it.get(), "RkNN", q2 != null);
            if (q2 != null) {
                return q2;
            }
            it.advance();
        }
        if ((this.flags & 9) == 0 && (q = OPTIMIZER.rkNNByDBID(this.relation, distanceQuery, k, this.flags)) != null) {
            return q;
        }
        if ((this.flags & 2) != 0) {
            return null;
        }
        this.logNotAccelerated("rknn");
        return new LinearScanRKNNByDBID<O>(distanceQuery, this.kNNByDBID());
    }

    public PrioritySearcher<O> priorityByObject() {
        return this.priorityByObject(Double.POSITIVE_INFINITY);
    }

    public PrioritySearcher<O> priorityByObject(double maxrange) {
        PrioritySearcher<O> q;
        int precompute = this.flags & 0x20;
        this.flags ^= precompute;
        DistanceQuery<O> distanceQuery = this.distanceQuery();
        this.flags ^= precompute;
        It it = Metadata.hierarchyOf(this.relation).iterChildrenReverse().filter(DistancePriorityIndex.class);
        while (it.valid()) {
            PrioritySearcher q2 = ((DistancePriorityIndex)it.get()).priorityByObject(distanceQuery, maxrange, this.flags);
            this.logUsing((Index)it.get(), "priority", q2 != null);
            if (q2 != null) {
                return q2;
            }
            it.advance();
        }
        if ((this.flags & 9) == 0 && (q = OPTIMIZER.priorityByObject(this.relation, distanceQuery, maxrange, this.flags)) != null) {
            return q;
        }
        if ((this.flags & 2) != 0) {
            return null;
        }
        this.logNotAccelerated("priority");
        if (distanceQuery instanceof PrimitiveDistanceQuery && EuclideanDistance.STATIC.equals(this.distance)) {
            PrimitiveDistanceQuery ndq = (PrimitiveDistanceQuery)distanceQuery;
            return new LinearScanEuclideanPrioritySearcher.ByObject(ndq);
        }
        return new LinearScanPrioritySearcher.ByObject<O>(distanceQuery);
    }

    public PrioritySearcher<DBIDRef> priorityByDBID() {
        return this.priorityByDBID(Double.POSITIVE_INFINITY);
    }

    public PrioritySearcher<DBIDRef> priorityByDBID(double maxrange) {
        PrioritySearcher<DBIDRef> q;
        int precompute = this.flags & 0x20;
        this.flags ^= precompute;
        DistanceQuery<O> distanceQuery = this.distanceQuery();
        this.flags ^= precompute;
        It it = Metadata.hierarchyOf(this.relation).iterChildrenReverse().filter(DistancePriorityIndex.class);
        while (it.valid()) {
            PrioritySearcher q2 = ((DistancePriorityIndex)it.get()).priorityByDBID(distanceQuery, maxrange, this.flags);
            this.logUsing((Index)it.get(), "priority", q2 != null);
            if (q2 != null) {
                return q2;
            }
            it.advance();
        }
        if ((this.flags & 9) == 0 && (q = OPTIMIZER.priorityByDBID(this.relation, distanceQuery, maxrange, this.flags)) != null) {
            return q;
        }
        if ((this.flags & 2) != 0) {
            return null;
        }
        this.logNotAccelerated("priority");
        if (distanceQuery instanceof PrimitiveDistanceQuery && EuclideanDistance.STATIC.equals(this.distance)) {
            PrimitiveDistanceQuery ndq = (PrimitiveDistanceQuery)distanceQuery;
            return new LinearScanEuclideanPrioritySearcher.ByDBID(ndq);
        }
        return new LinearScanPrioritySearcher.ByDBID<O>(distanceQuery);
    }

    private void logUsing(Index index, String kind, boolean used) {
        if (LOG.isDebuggingFinest()) {
            LOG.debugFinest((CharSequence)((used ? "Using" : "Not using") + " index for " + kind + " query: " + index));
        }
    }

    private void logNotAccelerated(String kind) {
        if (LOG.isDebuggingFinest()) {
            StringBuilder buf = new StringBuilder(200).append("Fallback to linear scan for ").append(kind).append(" query - no index was able to accelerate this query:");
            if (this.distance != null) {
                buf.append("\nDistance: ").append(this.distance.toString());
            } else if (this.distQuery != null) {
                buf.append("\nDistance: ").append(this.distQuery.getDistance().toString());
            }
            if (this.similarity != null) {
                buf.append("\nSimilarity: ").append(this.similarity.toString());
            } else if (this.simQuery != null) {
                buf.append("\nSimilarity: ").append(this.simQuery.getSimilarity().toString());
            }
            if (this.flags != 0) {
                buf.append(", hints:").append((this.flags & 1) == 0 ? "" : " linear").append((this.flags & 2) == 0 ? "" : " optimized").append((this.flags & 4) == 0 ? "" : " exact").append((this.flags & 8) == 0 ? "" : " cheap").append((this.flags & 0x10) == 0 ? "" : " no-cache");
            }
            LOG.debugFinest((CharSequence)buf.toString());
        }
    }

    private static QueryOptimizer initStaticOptimizer() {
        if (OPTIMIZER != null) {
            return OPTIMIZER;
        }
        String opt = System.getenv("elki.optimizer");
        if (opt != null) {
            if (opt.isEmpty()) {
                LOG.warning((CharSequence)"Optimizer disabled.");
                return DisableQueryOptimizer.STATIC;
            }
            try {
                Class clz = ELKIServiceRegistry.findImplementation(QueryOptimizer.class, (String)opt);
                if (clz == null) {
                    throw new AbortException("Could not find query optimizer: " + opt);
                }
                return (QueryOptimizer)ClassGenericsUtil.tryInstantiate(QueryOptimizer.class, (Class)clz, (Parameterization)new EmptyParameterization());
            }
            catch (ClassInstantiationException e) {
                throw new AbortException("Failed to initialize query optimizer: " + opt, (Throwable)e);
            }
        }
        return new EmpiricalQueryOptimizer();
    }
}

