/*
 * Decompiled with CFR 0.152.
 */
package elki.database.query;

import elki.database.ids.DBIDRef;
import elki.database.query.PrioritySearcher;
import elki.database.query.distance.DistanceQuery;
import elki.database.query.knn.KNNSearcher;
import elki.database.query.range.RangeSearcher;
import elki.database.query.rknn.RKNNSearcher;
import elki.database.query.similarity.SimilarityQuery;
import elki.database.relation.Relation;
import elki.distance.Distance;
import elki.similarity.Similarity;

public interface QueryOptimizer {
    default public <O> SimilarityQuery<O> getSimilarityQuery(Relation<? extends O> relation, Similarity<? super O> similarityFunction, int flags) {
        return null;
    }

    default public <O> DistanceQuery<O> getDistanceQuery(Relation<? extends O> relation, Distance<? super O> distanceFunction, int flags) {
        return null;
    }

    default public <O> KNNSearcher<O> kNNByObject(Relation<? extends O> relation, DistanceQuery<O> distanceQuery, int maxk, int flags) {
        return null;
    }

    default public <O> KNNSearcher<DBIDRef> kNNByDBID(Relation<? extends O> relation, DistanceQuery<O> distanceQuery, int maxk, int flags) {
        return null;
    }

    default public <O> RangeSearcher<O> rangeByObject(Relation<? extends O> relation, DistanceQuery<O> distanceQuery, double maxrange, int flags) {
        return null;
    }

    default public <O> RangeSearcher<DBIDRef> rangeByDBID(Relation<? extends O> relation, DistanceQuery<O> distanceQuery, double maxrange, int flags) {
        return null;
    }

    default public <O> RangeSearcher<O> similarityRangeByObject(Relation<? extends O> relation, SimilarityQuery<O> simQuery, double maxrange, int flags) {
        return null;
    }

    default public <O> RangeSearcher<DBIDRef> similarityRangeByDBID(Relation<? extends O> relation, SimilarityQuery<O> simQuery, double maxrange, int flags) {
        return null;
    }

    default public <O> RKNNSearcher<O> rkNNByObject(Relation<? extends O> relation, DistanceQuery<O> distanceQuery, int maxk, int flags) {
        return null;
    }

    default public <O> RKNNSearcher<DBIDRef> rkNNByDBID(Relation<? extends O> relation, DistanceQuery<O> distanceQuery, int maxk, int flags) {
        return null;
    }

    default public <O> PrioritySearcher<O> priorityByObject(Relation<? extends O> relation, DistanceQuery<O> distanceQuery, double maxrange, int flags) {
        return null;
    }

    default public <O> PrioritySearcher<DBIDRef> priorityByDBID(Relation<? extends O> relation, DistanceQuery<O> distanceQuery, double maxrange, int flags) {
        return null;
    }
}

