/*
 * Decompiled with CFR 0.152.
 */
package elki.database.query.distance;

import elki.database.ids.DBID;
import elki.database.ids.DBIDRange;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDs;
import elki.database.query.distance.DBIDDistanceQuery;
import elki.database.relation.Relation;
import elki.distance.DBIDDistance;
import elki.distance.DBIDRangeDistance;

public class DBIDRangeDistanceQuery
extends DBIDDistanceQuery {
    protected final DBIDRangeDistance distanceFunction;
    protected final DBIDRange range;

    public DBIDRangeDistanceQuery(Relation<DBID> relation, DBIDRangeDistance distanceFunction) {
        super(relation, (DBIDDistance)distanceFunction);
        this.range = DBIDUtil.assertRange((DBIDs)relation.getDBIDs());
        distanceFunction.checkRange(this.range);
        this.distanceFunction = distanceFunction;
    }

    @Override
    public double distance(DBIDRef id1, DBIDRef id2) {
        return this.distanceFunction.distance(this.range.getOffset(id1), this.range.getOffset(id2));
    }

    @Override
    public DBIDDistance getDistance() {
        return this.distanceFunction;
    }
}

