/*
 * Decompiled with CFR 0.152.
 */
package elki.database.query.distance;

import elki.data.NumberVector;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.query.LinearScanQuery;
import elki.database.query.PrioritySearcher;
import elki.database.query.distance.DistanceQuery;
import elki.distance.minkowski.EuclideanDistance;
import elki.distance.minkowski.SquaredEuclideanDistance;

public abstract class LinearScanEuclideanPrioritySearcher<Q, O extends NumberVector>
implements PrioritySearcher<Q>,
LinearScanQuery {
    protected DistanceQuery<O> distanceQuery;
    private DBIDIter iter;
    private O query;
    private double thresholdUp;
    private double thresholdsq;
    private double curdist;
    private double curdistsq;
    private static final SquaredEuclideanDistance SQUARED = SquaredEuclideanDistance.STATIC;

    public LinearScanEuclideanPrioritySearcher(DistanceQuery<O> distanceQuery) {
        this.distanceQuery = distanceQuery;
        assert (EuclideanDistance.STATIC.equals((Object)distanceQuery.getDistance()));
    }

    public PrioritySearcher<Q> realSearch(O query) {
        this.query = query;
        this.iter = this.distanceQuery.getRelation().iterDBIDs();
        this.thresholdUp = Double.POSITIVE_INFINITY;
        this.thresholdsq = Double.POSITIVE_INFINITY;
        this.curdistsq = Double.NaN;
        this.curdist = Double.NaN;
        return this;
    }

    public boolean valid() {
        return this.iter.valid();
    }

    public PrioritySearcher<Q> advance() {
        this.iter.advance();
        this.curdistsq = Double.NaN;
        this.curdist = Double.NaN;
        return this;
    }

    public int internalGetIndex() {
        return this.iter.internalGetIndex();
    }

    public PrioritySearcher<Q> decreaseCutoff(double threshold) {
        this.thresholdsq = threshold * threshold;
        this.thresholdUp = Math.nextUp(threshold);
        return this;
    }

    public double computeExactDistance() {
        return this.curdist == this.curdist ? this.curdist : (this.curdist = Math.sqrt(this.getSquaredDistance()));
    }

    public double getSquaredDistance() {
        return this.curdistsq == this.curdistsq ? this.curdistsq : (this.curdistsq = SQUARED.distance(this.query, (NumberVector)this.distanceQuery.getRelation().get((DBIDRef)this.iter)));
    }

    public double getApproximateAccuracy() {
        return this.curdist == this.curdist ? 0.0 : Double.NaN;
    }

    public double getApproximateDistance() {
        return this.curdist;
    }

    public double getLowerBound() {
        return this.curdist;
    }

    public double getUpperBound() {
        return this.curdist == this.curdist ? this.curdist : (this.thresholdsq == this.thresholdsq && this.getSquaredDistance() > this.thresholdsq ? this.thresholdUp : Double.NaN);
    }

    public double allLowerBound() {
        return this.iter.valid() ? 0.0 : Double.POSITIVE_INFINITY;
    }

    public static class ByDBID<O extends NumberVector>
    extends LinearScanEuclideanPrioritySearcher<DBIDRef, O> {
        public ByDBID(DistanceQuery<O> distanceQuery) {
            super(distanceQuery);
        }

        public PrioritySearcher<DBIDRef> search(DBIDRef query) {
            return this.realSearch((NumberVector)this.distanceQuery.getRelation().get(query));
        }
    }

    public static class ByObject<O extends NumberVector>
    extends LinearScanEuclideanPrioritySearcher<O, O> {
        public ByObject(DistanceQuery<O> distanceQuery) {
            super(distanceQuery);
        }

        public PrioritySearcher<O> search(O query) {
            return this.realSearch(query);
        }
    }
}

