/*
 * Decompiled with CFR 0.152.
 */
package elki.database.query.distance;

import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.query.LinearScanQuery;
import elki.database.query.PrioritySearcher;
import elki.database.query.distance.DistanceQuery;

public abstract class LinearScanPrioritySearcher<Q, O>
implements PrioritySearcher<Q>,
LinearScanQuery {
    protected DistanceQuery<O> distanceQuery;
    protected DBIDIter iter;
    protected O query;
    protected double curdist;

    public LinearScanPrioritySearcher(DistanceQuery<O> distanceQuery) {
        this.distanceQuery = distanceQuery;
    }

    protected PrioritySearcher<Q> realSearch(O query) {
        this.query = query;
        this.iter = this.distanceQuery.getRelation().iterDBIDs();
        this.curdist = Double.NaN;
        return this;
    }

    public boolean valid() {
        return this.iter.valid();
    }

    public PrioritySearcher<Q> advance() {
        this.iter.advance();
        this.curdist = Double.NaN;
        return this;
    }

    public int internalGetIndex() {
        return this.iter.internalGetIndex();
    }

    public PrioritySearcher<Q> decreaseCutoff(double threshold) {
        return this;
    }

    public double computeExactDistance() {
        return this.curdist == this.curdist ? this.curdist : (this.curdist = this.distanceQuery.distance(this.query, (DBIDRef)this.iter));
    }

    public double getApproximateAccuracy() {
        return this.curdist == this.curdist ? 0.0 : Double.NaN;
    }

    public double getApproximateDistance() {
        return this.curdist;
    }

    public double getLowerBound() {
        return this.curdist;
    }

    public double getUpperBound() {
        return this.curdist;
    }

    public double allLowerBound() {
        return this.iter.valid() ? 0.0 : Double.POSITIVE_INFINITY;
    }

    public static class ByDBID<O>
    extends LinearScanPrioritySearcher<DBIDRef, O> {
        public ByDBID(DistanceQuery<O> distanceQuery) {
            super(distanceQuery);
        }

        public PrioritySearcher<DBIDRef> search(DBIDRef query) {
            return this.realSearch(this.distanceQuery.getRelation().get(query));
        }
    }

    public static class ByObject<O>
    extends LinearScanPrioritySearcher<O, O> {
        public ByObject(DistanceQuery<O> distanceQuery) {
            super(distanceQuery);
        }

        public PrioritySearcher<O> search(O query) {
            return this.realSearch(query);
        }
    }
}

