/*
 * Decompiled with CFR 0.152.
 */
package elki.database.query.knn;

import elki.data.NumberVector;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.KNNHeap;
import elki.database.ids.KNNList;
import elki.database.query.distance.PrimitiveDistanceQuery;
import elki.database.query.knn.LinearScanPrimitiveKNNByObject;
import elki.database.relation.Relation;
import elki.distance.minkowski.EuclideanDistance;
import elki.distance.minkowski.SquaredEuclideanDistance;

public class LinearScanEuclideanKNNByObject<O extends NumberVector>
extends LinearScanPrimitiveKNNByObject<O> {
    public LinearScanEuclideanKNNByObject(PrimitiveDistanceQuery<O> distanceQuery) {
        super(distanceQuery);
        assert (EuclideanDistance.STATIC.equals((Object)distanceQuery.getDistance()));
    }

    @Override
    public KNNList getKNN(O obj, int k) {
        SquaredEuclideanDistance squared = SquaredEuclideanDistance.STATIC;
        Relation relation = this.relation;
        KNNHeap heap = DBIDUtil.newHeap((int)k);
        double max = Double.POSITIVE_INFINITY;
        DBIDIter iter = relation.iterDBIDs();
        while (iter.valid()) {
            double dist = squared.distance(obj, (NumberVector)relation.get((DBIDRef)iter));
            max = dist <= max ? heap.insert(dist, (DBIDRef)iter) : max;
            iter.advance();
        }
        return heap.toKNNListSqrt();
    }
}

