/*
 * Decompiled with CFR 0.152.
 */
package elki.database.query.knn;

import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.KNNHeap;
import elki.database.ids.KNNList;
import elki.database.query.LinearScanQuery;
import elki.database.query.distance.DistanceQuery;
import elki.database.query.knn.KNNSearcher;

public class LinearScanKNNByDBID<O>
implements KNNSearcher<DBIDRef>,
LinearScanQuery {
    private final DistanceQuery<O> distanceQuery;

    public LinearScanKNNByDBID(DistanceQuery<O> distanceQuery) {
        this.distanceQuery = distanceQuery;
    }

    public KNNList getKNN(DBIDRef id, int k) {
        DistanceQuery<O> dq = this.distanceQuery;
        KNNHeap heap = DBIDUtil.newHeap((int)k);
        double max = Double.POSITIVE_INFINITY;
        DBIDIter iter = dq.getRelation().iterDBIDs();
        while (iter.valid()) {
            double dist = dq.distance(id, (DBIDRef)iter);
            max = dist <= max ? heap.insert(dist, (DBIDRef)iter) : max;
            iter.advance();
        }
        return heap.toKNNList();
    }
}

