/*
 * Decompiled with CFR 0.152.
 */
package elki.database.query.knn;

import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.KNNHeap;
import elki.database.ids.KNNList;
import elki.database.query.LinearScanQuery;
import elki.database.query.distance.PrimitiveDistanceQuery;
import elki.database.query.knn.KNNSearcher;
import elki.database.relation.Relation;
import elki.distance.PrimitiveDistance;

public class LinearScanPrimitiveKNNByObject<O>
implements KNNSearcher<O>,
LinearScanQuery {
    private PrimitiveDistance<? super O> rawdist;
    protected Relation<? extends O> relation;

    public LinearScanPrimitiveKNNByObject(PrimitiveDistanceQuery<O> distanceQuery) {
        this.rawdist = distanceQuery.getDistance();
        this.relation = distanceQuery.getRelation();
    }

    public KNNList getKNN(O obj, int k) {
        PrimitiveDistance<? super O> rawdist = this.rawdist;
        Relation<? extends O> relation = this.relation;
        KNNHeap heap = DBIDUtil.newHeap((int)k);
        double max = Double.POSITIVE_INFINITY;
        DBIDIter iter = relation.iterDBIDs();
        while (iter.valid()) {
            double dist = rawdist.distance(obj, relation.get((DBIDRef)iter));
            max = dist <= max ? heap.insert(dist, (DBIDRef)iter) : max;
            iter.advance();
        }
        return heap.toKNNList();
    }
}

