/*
 * Decompiled with CFR 0.152.
 */
package elki.database.query.range;

import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.ModifiableDoubleDBIDList;
import elki.database.query.LinearScanQuery;
import elki.database.query.distance.DistanceQuery;
import elki.database.query.range.RangeSearcher;

public class LinearScanDistanceRangeByDBID<O>
implements RangeSearcher<DBIDRef>,
LinearScanQuery {
    private DistanceQuery<O> distanceQuery;

    public LinearScanDistanceRangeByDBID(DistanceQuery<O> distanceQuery) {
        this.distanceQuery = distanceQuery;
    }

    public ModifiableDoubleDBIDList getRange(DBIDRef id, double range, ModifiableDoubleDBIDList result) {
        DistanceQuery<O> dq = this.distanceQuery;
        DBIDIter iter = dq.getRelation().iterDBIDs();
        while (iter.valid()) {
            double currentDistance = dq.distance(id, (DBIDRef)iter);
            if (currentDistance <= range) {
                result.add(currentDistance, (DBIDRef)iter);
            }
            iter.advance();
        }
        return result;
    }
}

