/*
 * Decompiled with CFR 0.152.
 */
package elki.database.query.range;

import elki.data.NumberVector;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.ModifiableDoubleDBIDList;
import elki.database.query.LinearScanQuery;
import elki.database.query.distance.DistanceQuery;
import elki.database.query.range.RangeSearcher;
import elki.database.relation.Relation;
import elki.distance.minkowski.SquaredEuclideanDistance;

public class LinearScanEuclideanRangeByObject<O extends NumberVector>
implements RangeSearcher<O>,
LinearScanQuery {
    private Relation<? extends O> relation;

    public LinearScanEuclideanRangeByObject(DistanceQuery<O> distanceQuery) {
        this.relation = distanceQuery.getRelation();
    }

    public ModifiableDoubleDBIDList getRange(O obj, double range, ModifiableDoubleDBIDList result) {
        Relation<? extends O> relation = this.relation;
        SquaredEuclideanDistance squared = SquaredEuclideanDistance.STATIC;
        float frange = Math.nextUp((float)range);
        double sqrange = frange * frange;
        DBIDIter iter = relation.iterDBIDs();
        while (iter.valid()) {
            double sqdistance = squared.distance(obj, (NumberVector)relation.get((DBIDRef)iter));
            if (sqdistance <= sqrange) {
                result.add(Math.sqrt(sqdistance), (DBIDRef)iter);
            }
            iter.advance();
        }
        return result;
    }
}

