/*
 * Decompiled with CFR 0.152.
 */
package elki.database.query.range;

import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.ModifiableDoubleDBIDList;
import elki.database.query.LinearScanQuery;
import elki.database.query.distance.PrimitiveDistanceQuery;
import elki.database.query.range.RangeSearcher;
import elki.database.relation.Relation;
import elki.distance.PrimitiveDistance;

public class LinearScanPrimitiveDistanceRangeByObject<O>
implements RangeSearcher<O>,
LinearScanQuery {
    private PrimitiveDistanceQuery<O> distance;

    public LinearScanPrimitiveDistanceRangeByObject(PrimitiveDistanceQuery<O> distanceQuery) {
        this.distance = distanceQuery;
    }

    public ModifiableDoubleDBIDList getRange(O obj, double range, ModifiableDoubleDBIDList result) {
        PrimitiveDistance rawdist = this.distance.getDistance();
        Relation relation = this.distance.getRelation();
        DBIDIter iter = relation.iterDBIDs();
        while (iter.valid()) {
            double distance = rawdist.distance(obj, relation.get((DBIDRef)iter));
            if (distance <= range) {
                result.add(distance, (DBIDRef)iter);
            }
            iter.advance();
        }
        return result;
    }
}

