/*
 * Decompiled with CFR 0.152.
 */
package elki.database.query.range;

import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.ModifiableDoubleDBIDList;
import elki.database.query.LinearScanQuery;
import elki.database.query.range.RangeSearcher;
import elki.database.query.similarity.PrimitiveSimilarityQuery;
import elki.database.relation.Relation;
import elki.similarity.PrimitiveSimilarity;

public class LinearScanPrimitiveSimilarityRangeByObject<O>
implements RangeSearcher<O>,
LinearScanQuery {
    private PrimitiveSimilarityQuery<O> sim;

    public LinearScanPrimitiveSimilarityRangeByObject(PrimitiveSimilarityQuery<O> similarityQuery) {
        this.sim = similarityQuery;
    }

    public ModifiableDoubleDBIDList getRange(O obj, double range, ModifiableDoubleDBIDList result) {
        PrimitiveSimilarity sim = this.sim.getSimilarity();
        Relation relation = this.sim.getRelation();
        DBIDIter iter = relation.iterDBIDs();
        while (iter.valid()) {
            double similarity = sim.similarity(obj, relation.get((DBIDRef)iter));
            if (similarity >= range) {
                result.add(similarity, (DBIDRef)iter);
            }
            iter.advance();
        }
        return result;
    }
}

