/*
 * Decompiled with CFR 0.152.
 */
package elki.database.query.range;

import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.ModifiableDoubleDBIDList;
import elki.database.query.LinearScanQuery;
import elki.database.query.range.RangeSearcher;
import elki.database.query.similarity.SimilarityQuery;

public class LinearScanSimilarityRangeByDBID<O>
implements RangeSearcher<DBIDRef>,
LinearScanQuery {
    protected final SimilarityQuery<O> simQuery;

    public LinearScanSimilarityRangeByDBID(SimilarityQuery<O> simQuery) {
        this.simQuery = simQuery;
    }

    public ModifiableDoubleDBIDList getRange(DBIDRef id, double range, ModifiableDoubleDBIDList result) {
        DBIDIter iter = this.simQuery.getRelation().iterDBIDs();
        while (iter.valid()) {
            double currentSim = this.simQuery.similarity(id, (DBIDRef)iter);
            if (currentSim >= range) {
                result.add(currentSim, (DBIDRef)iter);
            }
            iter.advance();
        }
        return result;
    }
}

