/*
 * Decompiled with CFR 0.152.
 */
package elki.database.query.rknn;

import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DoubleDBIDList;
import elki.database.ids.DoubleDBIDListIter;
import elki.database.ids.KNNList;
import elki.database.ids.ModifiableDoubleDBIDList;
import elki.database.query.LinearScanQuery;
import elki.database.query.distance.DistanceQuery;
import elki.database.query.knn.KNNSearcher;
import elki.database.query.rknn.RKNNSearcher;

public class LinearScanRKNNByDBID<O>
implements RKNNSearcher<DBIDRef>,
LinearScanQuery {
    private DistanceQuery<O> distanceQuery;
    private KNNSearcher<DBIDRef> knnQuery;

    public LinearScanRKNNByDBID(DistanceQuery<O> distanceQuery, KNNSearcher<DBIDRef> knnQuery) {
        this.distanceQuery = distanceQuery;
        this.knnQuery = knnQuery;
    }

    public DoubleDBIDList getRKNN(DBIDRef id, int k) {
        ModifiableDoubleDBIDList rNNList = DBIDUtil.newDistanceDBIDList();
        DBIDIter iter = this.distanceQuery.getRelation().iterDBIDs();
        while (iter.valid()) {
            KNNList knn = this.knnQuery.getKNN((Object)iter, k);
            DoubleDBIDListIter n = knn.iter();
            while (n.valid()) {
                if (DBIDUtil.equal((DBIDRef)n, (DBIDRef)id)) {
                    rNNList.add(n.doubleValue(), (DBIDRef)iter);
                }
                n.advance();
            }
            iter.advance();
        }
        return rNNList.sort();
    }
}

