/*
 * Decompiled with CFR 0.152.
 */
package elki.database.query.rknn;

import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DoubleDBIDList;
import elki.database.ids.KNNList;
import elki.database.ids.ModifiableDoubleDBIDList;
import elki.database.query.LinearScanQuery;
import elki.database.query.distance.DistanceQuery;
import elki.database.query.knn.KNNSearcher;
import elki.database.query.rknn.RKNNSearcher;

public class LinearScanRKNNByObject<O>
implements RKNNSearcher<O>,
LinearScanQuery {
    private DistanceQuery<O> distanceQuery;
    private KNNSearcher<DBIDRef> knnQuery;

    public LinearScanRKNNByObject(DistanceQuery<O> distanceQuery, KNNSearcher<DBIDRef> knnQuery) {
        this.distanceQuery = distanceQuery;
        this.knnQuery = knnQuery;
    }

    public DoubleDBIDList getRKNN(O obj, int k) {
        ModifiableDoubleDBIDList rNNlist = DBIDUtil.newDistanceDBIDList();
        DBIDIter iter = this.distanceQuery.getRelation().iterDBIDs();
        while (iter.valid()) {
            KNNList knn = this.knnQuery.getKNN((Object)iter, k);
            double dist = this.distanceQuery.distance(obj, (DBIDRef)iter);
            int last = Math.min(k, knn.size()) - 1;
            if (last < k - 1 || dist <= knn.doubleValue(last)) {
                rNNlist.add(dist, (DBIDRef)iter);
            }
            iter.advance();
        }
        return rNNlist.sort();
    }
}

