/*
 * Decompiled with CFR 0.152.
 */
package elki.database.relation;

import elki.data.type.SimpleTypeInformation;
import elki.data.type.TypeUtil;
import elki.database.datastore.DataStoreUtil;
import elki.database.datastore.DoubleDataStore;
import elki.database.datastore.WritableDoubleDataStore;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDs;
import elki.database.ids.StaticDBIDs;
import elki.database.relation.DoubleRelation;

public class MaterializedDoubleRelation
implements DoubleRelation {
    private final DoubleDataStore content;
    private final StaticDBIDs ids;
    private String name;

    public MaterializedDoubleRelation(String name, DBIDs ids) {
        this(name, ids, (DoubleDataStore)DataStoreUtil.makeDoubleStorage((DBIDs)ids, (int)30));
    }

    public MaterializedDoubleRelation(String name, DBIDs ids, DoubleDataStore content) {
        this.ids = DBIDUtil.makeUnmodifiable((DBIDs)ids);
        this.name = name;
        this.content = content;
    }

    public double doubleValue(DBIDRef id) {
        return this.content.doubleValue(id);
    }

    public void set(DBIDRef id, double val) {
        assert (this.ids.contains(id));
        if (this.content instanceof WritableDoubleDataStore) {
            ((WritableDoubleDataStore)this.content).putDouble(id, val);
        }
    }

    @Deprecated
    public void insert(DBIDRef id, Double val) {
        assert (this.ids.contains(id));
        if (this.content instanceof WritableDoubleDataStore) {
            ((WritableDoubleDataStore)this.content).putDouble(id, val.doubleValue());
        }
    }

    public void delete(DBIDRef id) {
        assert (!this.ids.contains(id));
        if (this.content instanceof WritableDoubleDataStore) {
            ((WritableDoubleDataStore)this.content).delete(id);
        }
    }

    public StaticDBIDs getDBIDs() {
        return this.ids;
    }

    public DBIDIter iterDBIDs() {
        return this.ids.iter();
    }

    public int size() {
        return this.ids.size();
    }

    public SimpleTypeInformation<Double> getDataTypeInformation() {
        return TypeUtil.DOUBLE;
    }

    public String getLongName() {
        return this.name != null ? this.name : "Double";
    }
}

