/*
 * Decompiled with CFR 0.152.
 */
package elki.database.relation;

import elki.data.type.SimpleTypeInformation;
import elki.database.datastore.DataStore;
import elki.database.datastore.DataStoreUtil;
import elki.database.datastore.WritableDataStore;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDs;
import elki.database.ids.StaticDBIDs;
import elki.database.relation.ModifiableRelation;
import elki.index.DynamicIndex;
import elki.index.Index;
import elki.result.Metadata;
import elki.utilities.datastructures.iterator.It;
import elki.utilities.exceptions.AbortException;

public class MaterializedRelation<O>
implements ModifiableRelation<O> {
    private final SimpleTypeInformation<O> type;
    private final DataStore<O> content;
    private final StaticDBIDs ids;
    private String name;

    public MaterializedRelation(SimpleTypeInformation<O> type, DBIDs ids) {
        this(null, type, ids);
    }

    public MaterializedRelation(String name, SimpleTypeInformation<O> type, DBIDs ids) {
        this.type = type;
        this.ids = DBIDUtil.makeUnmodifiable((DBIDs)ids);
        this.name = name;
        this.content = DataStoreUtil.makeStorage((DBIDs)ids, (int)30, (Class)type.getRestrictionClass());
    }

    public MaterializedRelation(String name, SimpleTypeInformation<O> type, DBIDs ids, DataStore<O> content) {
        this.type = type;
        this.ids = DBIDUtil.makeUnmodifiable((DBIDs)ids);
        this.name = name;
        this.content = content;
    }

    public O get(DBIDRef id) {
        return (O)this.content.get(id);
    }

    public void insert(DBIDRef id, O val) {
        assert (this.ids.contains(id)) : "Object not yet in DBIDs.";
        if (!(this.content instanceof WritableDataStore)) {
            throw new AbortException("Data is stored in a non-writable data store. Modifications are not possible.");
        }
        ((WritableDataStore)this.content).put(id, val);
        It it = Metadata.hierarchyOf((Object)this).iterDescendants().filter(Index.class);
        while (it.valid()) {
            if (!(it.get() instanceof DynamicIndex)) {
                throw new AbortException("A non-dynamic index was added to this database. Modifications are not allowed, unless this index is removed.");
            }
            ((DynamicIndex)it.get()).insert(id);
            it.advance();
        }
    }

    public void delete(DBIDRef id) {
        assert (!this.ids.contains(id)) : "Object still in DBIDs.";
        if (!(this.content instanceof WritableDataStore)) {
            throw new AbortException("Data is stored in a non-writable data store. Modifications are not possible.");
        }
        It it = Metadata.hierarchyOf((Object)this).iterDescendants().filter(Index.class);
        while (it.valid()) {
            if (!(it.get() instanceof DynamicIndex)) {
                throw new AbortException("A non-dynamic index was added to this database. Modifications are not allowed, unless this index is removed.");
            }
            ((DynamicIndex)it.get()).delete(id);
            it.advance();
        }
        ((WritableDataStore)this.content).delete(id);
    }

    public StaticDBIDs getDBIDs() {
        return this.ids;
    }

    public DBIDIter iterDBIDs() {
        return this.ids.iter();
    }

    public int size() {
        return this.ids.size();
    }

    public SimpleTypeInformation<O> getDataTypeInformation() {
        return this.type;
    }

    public String getLongName() {
        return this.name != null ? this.name : this.type.toString();
    }
}

