/*
 * Decompiled with CFR 0.152.
 */
package elki.database.relation;

import elki.data.type.SimpleTypeInformation;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDs;
import elki.database.relation.Relation;
import elki.result.Metadata;

public class ProxyView<O>
implements Relation<O> {
    private DBIDs idview;
    private final Relation<O> inner;

    public ProxyView(DBIDs idview, Relation<O> inner) {
        this.idview = DBIDUtil.makeUnmodifiable((DBIDs)idview);
        this.inner = inner;
    }

    public O get(DBIDRef id) {
        assert (this.idview.contains(id)) : "Accessing object not included in view.";
        return (O)this.inner.get(id);
    }

    public DBIDs getDBIDs() {
        return this.idview;
    }

    public DBIDIter iterDBIDs() {
        return this.idview.iter();
    }

    public int size() {
        return this.idview.size();
    }

    public SimpleTypeInformation<O> getDataTypeInformation() {
        return this.inner.getDataTypeInformation();
    }

    public String getLongName() {
        return "Partition of " + Metadata.of(this.inner).getLongName();
    }

    public void setDBIDs(DBIDs ids) {
        this.idview = ids;
    }
}

